-- $Header: /devl/xcs/repo/env/Databases/CAEInterfaces/vhdsclibs/data/unisims/stan/SMODEL/MCB.vhd,v 1.10 2010/02/04 21:01:21 vandanad Exp $
-------------------------------------------------------
--  Copyright (c) 2008 Xilinx Inc.
--  All Right Reserved.
-------------------------------------------------------
--
--   ____  ____
--  /   /\/   / 
-- /___/  \  /     Vendor      : Xilinx 
-- \   \   \/      Version : 11.1
--  \   \          Description : 
--  /   /                      
-- /___/   /\      Filename    : MCB.vhd
-- \   \  /  \      
--  \__ \/\__ \                   
--                                 
--  Generated by    : /home/chen/xfoundry/HEAD/env/Databases/CAEInterfaces/LibraryWriters/bin/write_vhdl.pl
--  Revision: 1.0
--  532287 - Change default value of parameter CAL_CALIBRATION_MODE.
--  545576 - MEM_MDDR_ODS attribute update.
-------------------------------------------------------

----- CELL MCB -----

library IEEE;
use IEEE.STD_LOGIC_arith.all;
use IEEE.STD_LOGIC_1164.all;

library unisim;
use unisim.VCOMPONENTS.all; 

library secureip; 
use secureip.all; 
use unisim.vpkg.all;

  entity MCB is
    generic (
      ARB_NUM_TIME_SLOTS : integer := 12;
      ARB_TIME_SLOT_0 : bit_vector := "111111111111111111";
      ARB_TIME_SLOT_1 : bit_vector := "111111111111111111";
      ARB_TIME_SLOT_10 : bit_vector := "111111111111111111";
      ARB_TIME_SLOT_11 : bit_vector := "111111111111111111";
      ARB_TIME_SLOT_2 : bit_vector := "111111111111111111";
      ARB_TIME_SLOT_3 : bit_vector := "111111111111111111";
      ARB_TIME_SLOT_4 : bit_vector := "111111111111111111";
      ARB_TIME_SLOT_5 : bit_vector := "111111111111111111";
      ARB_TIME_SLOT_6 : bit_vector := "111111111111111111";
      ARB_TIME_SLOT_7 : bit_vector := "111111111111111111";
      ARB_TIME_SLOT_8 : bit_vector := "111111111111111111";
      ARB_TIME_SLOT_9 : bit_vector := "111111111111111111";
      CAL_BA : bit_vector := X"0";
      CAL_BYPASS : string := "YES";
      CAL_CA : bit_vector := X"000";
      CAL_CALIBRATION_MODE : string := "NOCALIBRATION";
      CAL_CLK_DIV : integer := 1;
      CAL_DELAY : string := "QUARTER";
      CAL_RA : bit_vector := X"0000";
      MEM_ADDR_ORDER : string := "BANK_ROW_COLUMN";
      MEM_BA_SIZE : integer := 3;
      MEM_BURST_LEN : integer := 8;
      MEM_CAS_LATENCY : integer := 4;
      MEM_CA_SIZE : integer := 11;
      MEM_DDR1_2_ODS : string := "FULL";
      MEM_DDR2_3_HIGH_TEMP_SR : string := "NORMAL";
      MEM_DDR2_3_PA_SR : string := "FULL";
      MEM_DDR2_ADD_LATENCY : integer := 0;
      MEM_DDR2_DIFF_DQS_EN : string := "YES";
      MEM_DDR2_RTT : string := "50OHMS";
      MEM_DDR2_WRT_RECOVERY : integer := 4;
      MEM_DDR3_ADD_LATENCY : string := "OFF";
      MEM_DDR3_AUTO_SR : string := "ENABLED";
      MEM_DDR3_CAS_LATENCY : integer := 7;
      MEM_DDR3_CAS_WR_LATENCY : integer := 5;
      MEM_DDR3_DYN_WRT_ODT : string := "OFF";
      MEM_DDR3_ODS : string := "DIV7";
      MEM_DDR3_RTT : string := "DIV2";
      MEM_DDR3_WRT_RECOVERY : integer := 7;
      MEM_MDDR_ODS : string := "FULL";
      MEM_MOBILE_PA_SR : string := "FULL";
      MEM_MOBILE_TC_SR : integer := 0;
      MEM_RAS_VAL : integer := 0;
      MEM_RA_SIZE : integer := 13;
      MEM_RCD_VAL : integer := 1;
      MEM_REFI_VAL : integer := 0;
      MEM_RFC_VAL : integer := 0;
      MEM_RP_VAL : integer := 0;
      MEM_RTP_VAL : integer := 0;
      MEM_TYPE : string := "DDR3";
      MEM_WIDTH : integer := 4;
      MEM_WR_VAL : integer := 0;
      MEM_WTR_VAL : integer := 3;
      PORT_CONFIG : string := "B32_B32_B32_B32"
    );

    port (
      ADDR                 : out std_logic_vector(14 downto 0);
      BA                   : out std_logic_vector(2 downto 0);
      CAS                  : out std_ulogic;
      CKE                  : out std_ulogic;
      DQIOWEN0             : out std_ulogic;
      DQON                 : out std_logic_vector(15 downto 0);
      DQOP                 : out std_logic_vector(15 downto 0);
      DQSIOWEN90N          : out std_ulogic;
      DQSIOWEN90P          : out std_ulogic;
      IOIDRPADD            : out std_ulogic;
      IOIDRPADDR           : out std_logic_vector(4 downto 0);
      IOIDRPBROADCAST      : out std_ulogic;
      IOIDRPCLK            : out std_ulogic;
      IOIDRPCS             : out std_ulogic;
      IOIDRPSDO            : out std_ulogic;
      IOIDRPTRAIN          : out std_ulogic;
      IOIDRPUPDATE         : out std_ulogic;
      LDMN                 : out std_ulogic;
      LDMP                 : out std_ulogic;
      ODT                  : out std_ulogic;
      P0CMDEMPTY           : out std_ulogic;
      P0CMDFULL            : out std_ulogic;
      P0RDCOUNT            : out std_logic_vector(6 downto 0);
      P0RDDATA             : out std_logic_vector(31 downto 0);
      P0RDEMPTY            : out std_ulogic;
      P0RDERROR            : out std_ulogic;
      P0RDFULL             : out std_ulogic;
      P0RDOVERFLOW         : out std_ulogic;
      P0WRCOUNT            : out std_logic_vector(6 downto 0);
      P0WREMPTY            : out std_ulogic;
      P0WRERROR            : out std_ulogic;
      P0WRFULL             : out std_ulogic;
      P0WRUNDERRUN         : out std_ulogic;
      P1CMDEMPTY           : out std_ulogic;
      P1CMDFULL            : out std_ulogic;
      P1RDCOUNT            : out std_logic_vector(6 downto 0);
      P1RDDATA             : out std_logic_vector(31 downto 0);
      P1RDEMPTY            : out std_ulogic;
      P1RDERROR            : out std_ulogic;
      P1RDFULL             : out std_ulogic;
      P1RDOVERFLOW         : out std_ulogic;
      P1WRCOUNT            : out std_logic_vector(6 downto 0);
      P1WREMPTY            : out std_ulogic;
      P1WRERROR            : out std_ulogic;
      P1WRFULL             : out std_ulogic;
      P1WRUNDERRUN         : out std_ulogic;
      P2CMDEMPTY           : out std_ulogic;
      P2CMDFULL            : out std_ulogic;
      P2COUNT              : out std_logic_vector(6 downto 0);
      P2EMPTY              : out std_ulogic;
      P2ERROR              : out std_ulogic;
      P2FULL               : out std_ulogic;
      P2RDDATA             : out std_logic_vector(31 downto 0);
      P2RDOVERFLOW         : out std_ulogic;
      P2WRUNDERRUN         : out std_ulogic;
      P3CMDEMPTY           : out std_ulogic;
      P3CMDFULL            : out std_ulogic;
      P3COUNT              : out std_logic_vector(6 downto 0);
      P3EMPTY              : out std_ulogic;
      P3ERROR              : out std_ulogic;
      P3FULL               : out std_ulogic;
      P3RDDATA             : out std_logic_vector(31 downto 0);
      P3RDOVERFLOW         : out std_ulogic;
      P3WRUNDERRUN         : out std_ulogic;
      P4CMDEMPTY           : out std_ulogic;
      P4CMDFULL            : out std_ulogic;
      P4COUNT              : out std_logic_vector(6 downto 0);
      P4EMPTY              : out std_ulogic;
      P4ERROR              : out std_ulogic;
      P4FULL               : out std_ulogic;
      P4RDDATA             : out std_logic_vector(31 downto 0);
      P4RDOVERFLOW         : out std_ulogic;
      P4WRUNDERRUN         : out std_ulogic;
      P5CMDEMPTY           : out std_ulogic;
      P5CMDFULL            : out std_ulogic;
      P5COUNT              : out std_logic_vector(6 downto 0);
      P5EMPTY              : out std_ulogic;
      P5ERROR              : out std_ulogic;
      P5FULL               : out std_ulogic;
      P5RDDATA             : out std_logic_vector(31 downto 0);
      P5RDOVERFLOW         : out std_ulogic;
      P5WRUNDERRUN         : out std_ulogic;
      RAS                  : out std_ulogic;
      RST                  : out std_ulogic;
      SELFREFRESHMODE      : out std_ulogic;
      STATUS               : out std_logic_vector(31 downto 0);
      UDMN                 : out std_ulogic;
      UDMP                 : out std_ulogic;
      UOCALSTART           : out std_ulogic;
      UOCMDREADYIN         : out std_ulogic;
      UODATA               : out std_logic_vector(7 downto 0);
      UODATAVALID          : out std_ulogic;
      UODONECAL            : out std_ulogic;
      UOREFRSHFLAG         : out std_ulogic;
      UOSDO                : out std_ulogic;
      WE                   : out std_ulogic;
      DQI                  : in std_logic_vector(15 downto 0);
      DQSIOIN              : in std_ulogic;
      DQSIOIP              : in std_ulogic;
      IOIDRPSDI            : in std_ulogic;
      P0ARBEN              : in std_ulogic;
      P0CMDBA              : in std_logic_vector(2 downto 0);
      P0CMDBL              : in std_logic_vector(5 downto 0);
      P0CMDCA              : in std_logic_vector(11 downto 0);
      P0CMDCLK             : in std_ulogic;
      P0CMDEN              : in std_ulogic;
      P0CMDINSTR           : in std_logic_vector(2 downto 0);
      P0CMDRA              : in std_logic_vector(14 downto 0);
      P0RDCLK              : in std_ulogic;
      P0RDEN               : in std_ulogic;
      P0RWRMASK            : in std_logic_vector(3 downto 0);
      P0WRCLK              : in std_ulogic;
      P0WRDATA             : in std_logic_vector(31 downto 0);
      P0WREN               : in std_ulogic;
      P1ARBEN              : in std_ulogic;
      P1CMDBA              : in std_logic_vector(2 downto 0);
      P1CMDBL              : in std_logic_vector(5 downto 0);
      P1CMDCA              : in std_logic_vector(11 downto 0);
      P1CMDCLK             : in std_ulogic;
      P1CMDEN              : in std_ulogic;
      P1CMDINSTR           : in std_logic_vector(2 downto 0);
      P1CMDRA              : in std_logic_vector(14 downto 0);
      P1RDCLK              : in std_ulogic;
      P1RDEN               : in std_ulogic;
      P1RWRMASK            : in std_logic_vector(3 downto 0);
      P1WRCLK              : in std_ulogic;
      P1WRDATA             : in std_logic_vector(31 downto 0);
      P1WREN               : in std_ulogic;
      P2ARBEN              : in std_ulogic;
      P2CLK                : in std_ulogic;
      P2CMDBA              : in std_logic_vector(2 downto 0);
      P2CMDBL              : in std_logic_vector(5 downto 0);
      P2CMDCA              : in std_logic_vector(11 downto 0);
      P2CMDCLK             : in std_ulogic;
      P2CMDEN              : in std_ulogic;
      P2CMDINSTR           : in std_logic_vector(2 downto 0);
      P2CMDRA              : in std_logic_vector(14 downto 0);
      P2EN                 : in std_ulogic;
      P2WRDATA             : in std_logic_vector(31 downto 0);
      P2WRMASK             : in std_logic_vector(3 downto 0);
      P3ARBEN              : in std_ulogic;
      P3CLK                : in std_ulogic;
      P3CMDBA              : in std_logic_vector(2 downto 0);
      P3CMDBL              : in std_logic_vector(5 downto 0);
      P3CMDCA              : in std_logic_vector(11 downto 0);
      P3CMDCLK             : in std_ulogic;
      P3CMDEN              : in std_ulogic;
      P3CMDINSTR           : in std_logic_vector(2 downto 0);
      P3CMDRA              : in std_logic_vector(14 downto 0);
      P3EN                 : in std_ulogic;
      P3WRDATA             : in std_logic_vector(31 downto 0);
      P3WRMASK             : in std_logic_vector(3 downto 0);
      P4ARBEN              : in std_ulogic;
      P4CLK                : in std_ulogic;
      P4CMDBA              : in std_logic_vector(2 downto 0);
      P4CMDBL              : in std_logic_vector(5 downto 0);
      P4CMDCA              : in std_logic_vector(11 downto 0);
      P4CMDCLK             : in std_ulogic;
      P4CMDEN              : in std_ulogic;
      P4CMDINSTR           : in std_logic_vector(2 downto 0);
      P4CMDRA              : in std_logic_vector(14 downto 0);
      P4EN                 : in std_ulogic;
      P4WRDATA             : in std_logic_vector(31 downto 0);
      P4WRMASK             : in std_logic_vector(3 downto 0);
      P5ARBEN              : in std_ulogic;
      P5CLK                : in std_ulogic;
      P5CMDBA              : in std_logic_vector(2 downto 0);
      P5CMDBL              : in std_logic_vector(5 downto 0);
      P5CMDCA              : in std_logic_vector(11 downto 0);
      P5CMDCLK             : in std_ulogic;
      P5CMDEN              : in std_ulogic;
      P5CMDINSTR           : in std_logic_vector(2 downto 0);
      P5CMDRA              : in std_logic_vector(14 downto 0);
      P5EN                 : in std_ulogic;
      P5WRDATA             : in std_logic_vector(31 downto 0);
      P5WRMASK             : in std_logic_vector(3 downto 0);
      PLLCE                : in std_logic_vector(1 downto 0);
      PLLCLK               : in std_logic_vector(1 downto 0);
      PLLLOCK              : in std_ulogic;
      RECAL                : in std_ulogic;
      SELFREFRESHENTER     : in std_ulogic;
      SYSRST               : in std_ulogic;
      UDQSIOIN             : in std_ulogic;
      UDQSIOIP             : in std_ulogic;
      UIADD                : in std_ulogic;
      UIADDR               : in std_logic_vector(4 downto 0);
      UIBROADCAST          : in std_ulogic;
      UICLK                : in std_ulogic;
      UICMD                : in std_ulogic;
      UICMDEN              : in std_ulogic;
      UICMDIN              : in std_ulogic;
      UICS                 : in std_ulogic;
      UIDONECAL            : in std_ulogic;
      UIDQCOUNT            : in std_logic_vector(3 downto 0);
      UIDQLOWERDEC         : in std_ulogic;
      UIDQLOWERINC         : in std_ulogic;
      UIDQUPPERDEC         : in std_ulogic;
      UIDQUPPERINC         : in std_ulogic;
      UIDRPUPDATE          : in std_ulogic;
      UILDQSDEC            : in std_ulogic;
      UILDQSINC            : in std_ulogic;
      UIREAD               : in std_ulogic;
      UISDI                : in std_ulogic;
      UIUDQSDEC            : in std_ulogic;
      UIUDQSINC            : in std_ulogic      
    );
  end MCB;

  architecture MCB_V of MCB is
    component MCB_WRAP
      generic (
        ARB_NUM_TIME_SLOTS : integer;
        ARB_TIME_SLOT_0 : string;
        ARB_TIME_SLOT_1 : string;
        ARB_TIME_SLOT_10 : string;
        ARB_TIME_SLOT_11 : string;
        ARB_TIME_SLOT_2 : string;
        ARB_TIME_SLOT_3 : string;
        ARB_TIME_SLOT_4 : string;
        ARB_TIME_SLOT_5 : string;
        ARB_TIME_SLOT_6 : string;
        ARB_TIME_SLOT_7 : string;
        ARB_TIME_SLOT_8 : string;
        ARB_TIME_SLOT_9 : string;
        CAL_BA : string;
        CAL_BYPASS : string;
        CAL_CA : string;
        CAL_CALIBRATION_MODE : string;
        CAL_CLK_DIV : integer;
        CAL_DELAY : string;
        CAL_RA : string;
        MEM_ADDR_ORDER : string;
        MEM_BA_SIZE : integer;
        MEM_BURST_LEN : integer;
        MEM_CAS_LATENCY : integer;
        MEM_CA_SIZE : integer;
        MEM_DDR1_2_ODS : string;
        MEM_DDR2_3_HIGH_TEMP_SR : string;
        MEM_DDR2_3_PA_SR : string;
        MEM_DDR2_ADD_LATENCY : integer;
        MEM_DDR2_DIFF_DQS_EN : string;
        MEM_DDR2_RTT : string;
        MEM_DDR2_WRT_RECOVERY : integer;
        MEM_DDR3_ADD_LATENCY : string;
        MEM_DDR3_AUTO_SR : string;
        MEM_DDR3_CAS_LATENCY : integer;
        MEM_DDR3_CAS_WR_LATENCY : integer;
        MEM_DDR3_DYN_WRT_ODT : string;
        MEM_DDR3_ODS : string;
        MEM_DDR3_RTT : string;
        MEM_DDR3_WRT_RECOVERY : integer;
        MEM_MDDR_ODS : string;
        MEM_MOBILE_PA_SR : string;
        MEM_MOBILE_TC_SR : integer;
        MEM_RAS_VAL : integer;
        MEM_RA_SIZE : integer;
        MEM_RCD_VAL : integer;
        MEM_REFI_VAL : integer;
        MEM_RFC_VAL : integer;
        MEM_RP_VAL : integer;
        MEM_RTP_VAL : integer;
        MEM_TYPE : string;
        MEM_WIDTH : integer;
        MEM_WR_VAL : integer;
        MEM_WTR_VAL : integer;
        PORT_CONFIG : string        
      );
      
      port (
        ADDR                 : out std_logic_vector(14 downto 0);
        BA                   : out std_logic_vector(2 downto 0);
        CAS                  : out std_ulogic;
        CKE                  : out std_ulogic;
        DQIOWEN0             : out std_ulogic;
        DQON                 : out std_logic_vector(15 downto 0);
        DQOP                 : out std_logic_vector(15 downto 0);
        DQSIOWEN90N          : out std_ulogic;
        DQSIOWEN90P          : out std_ulogic;
        IOIDRPADD            : out std_ulogic;
        IOIDRPADDR           : out std_logic_vector(4 downto 0);
        IOIDRPBROADCAST      : out std_ulogic;
        IOIDRPCLK            : out std_ulogic;
        IOIDRPCS             : out std_ulogic;
        IOIDRPSDO            : out std_ulogic;
        IOIDRPTRAIN          : out std_ulogic;
        IOIDRPUPDATE         : out std_ulogic;
        LDMN                 : out std_ulogic;
        LDMP                 : out std_ulogic;
        ODT                  : out std_ulogic;
        P0CMDEMPTY           : out std_ulogic;
        P0CMDFULL            : out std_ulogic;
        P0RDCOUNT            : out std_logic_vector(6 downto 0);
        P0RDDATA             : out std_logic_vector(31 downto 0);
        P0RDEMPTY            : out std_ulogic;
        P0RDERROR            : out std_ulogic;
        P0RDFULL             : out std_ulogic;
        P0RDOVERFLOW         : out std_ulogic;
        P0WRCOUNT            : out std_logic_vector(6 downto 0);
        P0WREMPTY            : out std_ulogic;
        P0WRERROR            : out std_ulogic;
        P0WRFULL             : out std_ulogic;
        P0WRUNDERRUN         : out std_ulogic;
        P1CMDEMPTY           : out std_ulogic;
        P1CMDFULL            : out std_ulogic;
        P1RDCOUNT            : out std_logic_vector(6 downto 0);
        P1RDDATA             : out std_logic_vector(31 downto 0);
        P1RDEMPTY            : out std_ulogic;
        P1RDERROR            : out std_ulogic;
        P1RDFULL             : out std_ulogic;
        P1RDOVERFLOW         : out std_ulogic;
        P1WRCOUNT            : out std_logic_vector(6 downto 0);
        P1WREMPTY            : out std_ulogic;
        P1WRERROR            : out std_ulogic;
        P1WRFULL             : out std_ulogic;
        P1WRUNDERRUN         : out std_ulogic;
        P2CMDEMPTY           : out std_ulogic;
        P2CMDFULL            : out std_ulogic;
        P2COUNT              : out std_logic_vector(6 downto 0);
        P2EMPTY              : out std_ulogic;
        P2ERROR              : out std_ulogic;
        P2FULL               : out std_ulogic;
        P2RDDATA             : out std_logic_vector(31 downto 0);
        P2RDOVERFLOW         : out std_ulogic;
        P2WRUNDERRUN         : out std_ulogic;
        P3CMDEMPTY           : out std_ulogic;
        P3CMDFULL            : out std_ulogic;
        P3COUNT              : out std_logic_vector(6 downto 0);
        P3EMPTY              : out std_ulogic;
        P3ERROR              : out std_ulogic;
        P3FULL               : out std_ulogic;
        P3RDDATA             : out std_logic_vector(31 downto 0);
        P3RDOVERFLOW         : out std_ulogic;
        P3WRUNDERRUN         : out std_ulogic;
        P4CMDEMPTY           : out std_ulogic;
        P4CMDFULL            : out std_ulogic;
        P4COUNT              : out std_logic_vector(6 downto 0);
        P4EMPTY              : out std_ulogic;
        P4ERROR              : out std_ulogic;
        P4FULL               : out std_ulogic;
        P4RDDATA             : out std_logic_vector(31 downto 0);
        P4RDOVERFLOW         : out std_ulogic;
        P4WRUNDERRUN         : out std_ulogic;
        P5CMDEMPTY           : out std_ulogic;
        P5CMDFULL            : out std_ulogic;
        P5COUNT              : out std_logic_vector(6 downto 0);
        P5EMPTY              : out std_ulogic;
        P5ERROR              : out std_ulogic;
        P5FULL               : out std_ulogic;
        P5RDDATA             : out std_logic_vector(31 downto 0);
        P5RDOVERFLOW         : out std_ulogic;
        P5WRUNDERRUN         : out std_ulogic;
        RAS                  : out std_ulogic;
        RST                  : out std_ulogic;
        SELFREFRESHMODE      : out std_ulogic;
        STATUS               : out std_logic_vector(31 downto 0);
        UDMN                 : out std_ulogic;
        UDMP                 : out std_ulogic;
        UOCALSTART           : out std_ulogic;
        UOCMDREADYIN         : out std_ulogic;
        UODATA               : out std_logic_vector(7 downto 0);
        UODATAVALID          : out std_ulogic;
        UODONECAL            : out std_ulogic;
        UOREFRSHFLAG         : out std_ulogic;
        UOSDO                : out std_ulogic;
        WE                   : out std_ulogic;
        DQI                  : in std_logic_vector(15 downto 0);
        DQSIOIN              : in std_ulogic;
        DQSIOIP              : in std_ulogic;
        IOIDRPSDI            : in std_ulogic;
        P0ARBEN              : in std_ulogic;
        P0CMDBA              : in std_logic_vector(2 downto 0);
        P0CMDBL              : in std_logic_vector(5 downto 0);
        P0CMDCA              : in std_logic_vector(11 downto 0);
        P0CMDCLK             : in std_ulogic;
        P0CMDEN              : in std_ulogic;
        P0CMDINSTR           : in std_logic_vector(2 downto 0);
        P0CMDRA              : in std_logic_vector(14 downto 0);
        P0RDCLK              : in std_ulogic;
        P0RDEN               : in std_ulogic;
        P0RWRMASK            : in std_logic_vector(3 downto 0);
        P0WRCLK              : in std_ulogic;
        P0WRDATA             : in std_logic_vector(31 downto 0);
        P0WREN               : in std_ulogic;
        P1ARBEN              : in std_ulogic;
        P1CMDBA              : in std_logic_vector(2 downto 0);
        P1CMDBL              : in std_logic_vector(5 downto 0);
        P1CMDCA              : in std_logic_vector(11 downto 0);
        P1CMDCLK             : in std_ulogic;
        P1CMDEN              : in std_ulogic;
        P1CMDINSTR           : in std_logic_vector(2 downto 0);
        P1CMDRA              : in std_logic_vector(14 downto 0);
        P1RDCLK              : in std_ulogic;
        P1RDEN               : in std_ulogic;
        P1RWRMASK            : in std_logic_vector(3 downto 0);
        P1WRCLK              : in std_ulogic;
        P1WRDATA             : in std_logic_vector(31 downto 0);
        P1WREN               : in std_ulogic;
        P2ARBEN              : in std_ulogic;
        P2CLK                : in std_ulogic;
        P2CMDBA              : in std_logic_vector(2 downto 0);
        P2CMDBL              : in std_logic_vector(5 downto 0);
        P2CMDCA              : in std_logic_vector(11 downto 0);
        P2CMDCLK             : in std_ulogic;
        P2CMDEN              : in std_ulogic;
        P2CMDINSTR           : in std_logic_vector(2 downto 0);
        P2CMDRA              : in std_logic_vector(14 downto 0);
        P2EN                 : in std_ulogic;
        P2WRDATA             : in std_logic_vector(31 downto 0);
        P2WRMASK             : in std_logic_vector(3 downto 0);
        P3ARBEN              : in std_ulogic;
        P3CLK                : in std_ulogic;
        P3CMDBA              : in std_logic_vector(2 downto 0);
        P3CMDBL              : in std_logic_vector(5 downto 0);
        P3CMDCA              : in std_logic_vector(11 downto 0);
        P3CMDCLK             : in std_ulogic;
        P3CMDEN              : in std_ulogic;
        P3CMDINSTR           : in std_logic_vector(2 downto 0);
        P3CMDRA              : in std_logic_vector(14 downto 0);
        P3EN                 : in std_ulogic;
        P3WRDATA             : in std_logic_vector(31 downto 0);
        P3WRMASK             : in std_logic_vector(3 downto 0);
        P4ARBEN              : in std_ulogic;
        P4CLK                : in std_ulogic;
        P4CMDBA              : in std_logic_vector(2 downto 0);
        P4CMDBL              : in std_logic_vector(5 downto 0);
        P4CMDCA              : in std_logic_vector(11 downto 0);
        P4CMDCLK             : in std_ulogic;
        P4CMDEN              : in std_ulogic;
        P4CMDINSTR           : in std_logic_vector(2 downto 0);
        P4CMDRA              : in std_logic_vector(14 downto 0);
        P4EN                 : in std_ulogic;
        P4WRDATA             : in std_logic_vector(31 downto 0);
        P4WRMASK             : in std_logic_vector(3 downto 0);
        P5ARBEN              : in std_ulogic;
        P5CLK                : in std_ulogic;
        P5CMDBA              : in std_logic_vector(2 downto 0);
        P5CMDBL              : in std_logic_vector(5 downto 0);
        P5CMDCA              : in std_logic_vector(11 downto 0);
        P5CMDCLK             : in std_ulogic;
        P5CMDEN              : in std_ulogic;
        P5CMDINSTR           : in std_logic_vector(2 downto 0);
        P5CMDRA              : in std_logic_vector(14 downto 0);
        P5EN                 : in std_ulogic;
        P5WRDATA             : in std_logic_vector(31 downto 0);
        P5WRMASK             : in std_logic_vector(3 downto 0);
        PLLCE                : in std_logic_vector(1 downto 0);
        PLLCLK               : in std_logic_vector(1 downto 0);
        PLLLOCK              : in std_ulogic;
        RECAL                : in std_ulogic;
        SELFREFRESHENTER     : in std_ulogic;
        SYSRST               : in std_ulogic;
        UDQSIOIN             : in std_ulogic;
        UDQSIOIP             : in std_ulogic;
        UIADD                : in std_ulogic;
        UIADDR               : in std_logic_vector(4 downto 0);
        UIBROADCAST          : in std_ulogic;
        UICLK                : in std_ulogic;
        UICMD                : in std_ulogic;
        UICMDEN              : in std_ulogic;
        UICMDIN              : in std_ulogic;
        UICS                 : in std_ulogic;
        UIDONECAL            : in std_ulogic;
        UIDQCOUNT            : in std_logic_vector(3 downto 0);
        UIDQLOWERDEC         : in std_ulogic;
        UIDQLOWERINC         : in std_ulogic;
        UIDQUPPERDEC         : in std_ulogic;
        UIDQUPPERINC         : in std_ulogic;
        UIDRPUPDATE          : in std_ulogic;
        UILDQSDEC            : in std_ulogic;
        UILDQSINC            : in std_ulogic;
        UIREAD               : in std_ulogic;
        UISDI                : in std_ulogic;
        UIUDQSDEC            : in std_ulogic;
        UIUDQSINC            : in std_ulogic;        
        GSR                  : in std_ulogic
      );
    end component;
    
    constant IN_DELAY : time := 0 ps;
    constant OUT_DELAY : time := 100 ps;
    constant INCLK_DELAY : time := 0 ps;
    constant OUTCLK_DELAY : time := 100 ps;

    function boolean_to_string(bool: boolean)
    return string is
    begin
      if bool then
        return "TRUE";
      else
        return "FALSE";
      end if;
    end boolean_to_string;

    function getstrlength (
           in_vec : std_logic_vector)
    return integer is
     variable string_length : integer;
    begin
     if ((in_vec'length mod 4) = 0) then
      string_length := in_vec'length/4;
    elsif ((in_vec'length mod 4) > 0) then
      string_length := in_vec'length/4 + 1;
    end if;
    return string_length;
    end getstrlength;

    -- Convert bit_vector to std_logic_vector
    constant ARB_TIME_SLOT_0_BINARY : std_logic_vector(17 downto 0) := To_StdLogicVector(ARB_TIME_SLOT_0)(17 downto 0);
    constant ARB_TIME_SLOT_10_BINARY : std_logic_vector(17 downto 0) := To_StdLogicVector(ARB_TIME_SLOT_10)(17 downto 0);
    constant ARB_TIME_SLOT_11_BINARY : std_logic_vector(17 downto 0) := To_StdLogicVector(ARB_TIME_SLOT_11)(17 downto 0);
    constant ARB_TIME_SLOT_1_BINARY : std_logic_vector(17 downto 0) := To_StdLogicVector(ARB_TIME_SLOT_1)(17 downto 0);
    constant ARB_TIME_SLOT_2_BINARY : std_logic_vector(17 downto 0) := To_StdLogicVector(ARB_TIME_SLOT_2)(17 downto 0);
    constant ARB_TIME_SLOT_3_BINARY : std_logic_vector(17 downto 0) := To_StdLogicVector(ARB_TIME_SLOT_3)(17 downto 0);
    constant ARB_TIME_SLOT_4_BINARY : std_logic_vector(17 downto 0) := To_StdLogicVector(ARB_TIME_SLOT_4)(17 downto 0);
    constant ARB_TIME_SLOT_5_BINARY : std_logic_vector(17 downto 0) := To_StdLogicVector(ARB_TIME_SLOT_5)(17 downto 0);
    constant ARB_TIME_SLOT_6_BINARY : std_logic_vector(17 downto 0) := To_StdLogicVector(ARB_TIME_SLOT_6)(17 downto 0);
    constant ARB_TIME_SLOT_7_BINARY : std_logic_vector(17 downto 0) := To_StdLogicVector(ARB_TIME_SLOT_7)(17 downto 0);
    constant ARB_TIME_SLOT_8_BINARY : std_logic_vector(17 downto 0) := To_StdLogicVector(ARB_TIME_SLOT_8)(17 downto 0);
    constant ARB_TIME_SLOT_9_BINARY : std_logic_vector(17 downto 0) := To_StdLogicVector(ARB_TIME_SLOT_9)(17 downto 0);
    constant CAL_BA_BINARY : std_logic_vector(2 downto 0) := To_StdLogicVector(CAL_BA)(2 downto 0);
    constant CAL_CA_BINARY : std_logic_vector(11 downto 0) := To_StdLogicVector(CAL_CA)(11 downto 0);
    constant CAL_RA_BINARY : std_logic_vector(14 downto 0) := To_StdLogicVector(CAL_RA)(14 downto 0);

    -- Get String Length
    constant CAL_CA_STRLEN : integer := getstrlength(CAL_CA_BINARY);
    constant CAL_BA_STRLEN : integer := getstrlength(CAL_BA_BINARY);
    constant CAL_RA_STRLEN : integer := getstrlength(CAL_RA_BINARY);

    
    -- Convert std_logic_vector to string
    constant ARB_TIME_SLOT_0_STRING : string := SLV_TO_STR(ARB_TIME_SLOT_0_BINARY);
    constant ARB_TIME_SLOT_10_STRING : string := SLV_TO_STR(ARB_TIME_SLOT_10_BINARY);
    constant ARB_TIME_SLOT_11_STRING : string := SLV_TO_STR(ARB_TIME_SLOT_11_BINARY);
    constant ARB_TIME_SLOT_1_STRING : string := SLV_TO_STR(ARB_TIME_SLOT_1_BINARY);
    constant ARB_TIME_SLOT_2_STRING : string := SLV_TO_STR(ARB_TIME_SLOT_2_BINARY);
    constant ARB_TIME_SLOT_3_STRING : string := SLV_TO_STR(ARB_TIME_SLOT_3_BINARY);
    constant ARB_TIME_SLOT_4_STRING : string := SLV_TO_STR(ARB_TIME_SLOT_4_BINARY);
    constant ARB_TIME_SLOT_5_STRING : string := SLV_TO_STR(ARB_TIME_SLOT_5_BINARY);
    constant ARB_TIME_SLOT_6_STRING : string := SLV_TO_STR(ARB_TIME_SLOT_6_BINARY);
    constant ARB_TIME_SLOT_7_STRING : string := SLV_TO_STR(ARB_TIME_SLOT_7_BINARY);
    constant ARB_TIME_SLOT_8_STRING : string := SLV_TO_STR(ARB_TIME_SLOT_8_BINARY);
    constant ARB_TIME_SLOT_9_STRING : string := SLV_TO_STR(ARB_TIME_SLOT_9_BINARY);
    constant CAL_BA_STRING : string := SLV_TO_HEX(CAL_BA_BINARY, CAL_BA_STRLEN);
    constant CAL_CA_STRING : string := SLV_TO_HEX(CAL_CA_BINARY, CAL_CA_STRLEN);
    constant CAL_RA_STRING : string := SLV_TO_HEX(CAL_RA_BINARY, CAL_RA_STRLEN);
    
    signal ARB_NUM_TIME_SLOTS_BINARY : std_ulogic;
    signal CAL_BYPASS_BINARY : std_ulogic;
    signal CAL_CALIBRATION_MODE_BINARY : std_ulogic;
    signal CAL_CLK_DIV_BINARY : std_logic_vector(2 downto 0);
    signal CAL_DELAY_BINARY : std_logic_vector(1 downto 0);
    signal MEM_ADDR_ORDER_BINARY : std_ulogic;
    signal MEM_BA_SIZE_BINARY : std_ulogic;
    signal MEM_BURST_LEN_BINARY : std_logic_vector(2 downto 0);
    signal MEM_CAS_LATENCY_BINARY : std_logic_vector(2 downto 0);
    signal MEM_CA_SIZE_BINARY : std_logic_vector(1 downto 0);
    signal MEM_DDR1_2_ODS_BINARY : std_ulogic;
    signal MEM_DDR2_3_HIGH_TEMP_SR_BINARY : std_ulogic;
    signal MEM_DDR2_3_PA_SR_BINARY : std_logic_vector(2 downto 0);
    signal MEM_DDR2_ADD_LATENCY_BINARY : std_logic_vector(2 downto 0);
    signal MEM_DDR2_DIFF_DQS_EN_BINARY : std_ulogic;
    signal MEM_DDR2_RTT_BINARY : std_logic_vector(1 downto 0);
    signal MEM_DDR2_WRT_RECOVERY_BINARY : std_logic_vector(2 downto 0);
    signal MEM_DDR3_ADD_LATENCY_BINARY : std_logic_vector(1 downto 0);
    signal MEM_DDR3_AUTO_SR_BINARY : std_ulogic;
    signal MEM_DDR3_CAS_LATENCY_BINARY : std_logic_vector(3 downto 0);
    signal MEM_DDR3_CAS_WR_LATENCY_BINARY : std_logic_vector(2 downto 0);
    signal MEM_DDR3_DYN_WRT_ODT_BINARY : std_logic_vector(1 downto 0);
    signal MEM_DDR3_ODS_BINARY : std_logic_vector(1 downto 0);
    signal MEM_DDR3_RTT_BINARY : std_logic_vector(2 downto 0);
    signal MEM_DDR3_WRT_RECOVERY_BINARY : std_logic_vector(2 downto 0);
    signal MEM_MDDR_ODS_BINARY : std_logic_vector(2 downto 0);
    signal MEM_MOBILE_PA_SR_BINARY : std_logic_vector(2 downto 0);
    signal MEM_MOBILE_TC_SR_BINARY : std_logic_vector(1 downto 0);
    signal MEM_RAS_VAL_BINARY : std_logic_vector(4 downto 0);
    signal MEM_RA_SIZE_BINARY : std_logic_vector(1 downto 0);
    signal MEM_RCD_VAL_BINARY : std_logic_vector(2 downto 0);
    signal MEM_REFI_VAL_BINARY : std_logic_vector(11 downto 0);
    signal MEM_RFC_VAL_BINARY : std_logic_vector(7 downto 0);
    signal MEM_RP_VAL_BINARY : std_logic_vector(3 downto 0);
    signal MEM_RTP_VAL_BINARY : std_logic_vector(2 downto 0);
    signal MEM_TYPE_BINARY : std_logic_vector(2 downto 0);
    signal MEM_WIDTH_BINARY : std_logic_vector(1 downto 0);
    signal MEM_WR_VAL_BINARY : std_logic_vector(2 downto 0);
    signal MEM_WTR_VAL_BINARY : std_logic_vector(2 downto 0);
    signal PORT_CONFIG_BINARY : std_logic_vector(2 downto 0);
    
    signal ADDR_out : std_logic_vector(14 downto 0);
    signal BA_out : std_logic_vector(2 downto 0);
    signal CAS_out : std_ulogic;
    signal CKE_out : std_ulogic;
    signal DQIOWEN0_out : std_ulogic;
    signal DQON_out : std_logic_vector(15 downto 0);
    signal DQOP_out : std_logic_vector(15 downto 0);
    signal DQSIOWEN90N_out : std_ulogic;
    signal DQSIOWEN90P_out : std_ulogic;
    signal IOIDRPADDR_out : std_logic_vector(4 downto 0);
    signal IOIDRPADD_out : std_ulogic;
    signal IOIDRPBROADCAST_out : std_ulogic;
    signal IOIDRPCLK_out : std_ulogic;
    signal IOIDRPCS_out : std_ulogic;
    signal IOIDRPSDO_out : std_ulogic;
    signal IOIDRPTRAIN_out : std_ulogic;
    signal IOIDRPUPDATE_out : std_ulogic;
    signal LDMN_out : std_ulogic;
    signal LDMP_out : std_ulogic;
    signal ODT_out : std_ulogic;
    signal P0CMDEMPTY_out : std_ulogic;
    signal P0CMDFULL_out : std_ulogic;
    signal P0RDCOUNT_out : std_logic_vector(6 downto 0);
    signal P0RDDATA_out : std_logic_vector(31 downto 0);
    signal P0RDEMPTY_out : std_ulogic;
    signal P0RDERROR_out : std_ulogic;
    signal P0RDFULL_out : std_ulogic;
    signal P0RDOVERFLOW_out : std_ulogic;
    signal P0WRCOUNT_out : std_logic_vector(6 downto 0);
    signal P0WREMPTY_out : std_ulogic;
    signal P0WRERROR_out : std_ulogic;
    signal P0WRFULL_out : std_ulogic;
    signal P0WRUNDERRUN_out : std_ulogic;
    signal P1CMDEMPTY_out : std_ulogic;
    signal P1CMDFULL_out : std_ulogic;
    signal P1RDCOUNT_out : std_logic_vector(6 downto 0);
    signal P1RDDATA_out : std_logic_vector(31 downto 0);
    signal P1RDEMPTY_out : std_ulogic;
    signal P1RDERROR_out : std_ulogic;
    signal P1RDFULL_out : std_ulogic;
    signal P1RDOVERFLOW_out : std_ulogic;
    signal P1WRCOUNT_out : std_logic_vector(6 downto 0);
    signal P1WREMPTY_out : std_ulogic;
    signal P1WRERROR_out : std_ulogic;
    signal P1WRFULL_out : std_ulogic;
    signal P1WRUNDERRUN_out : std_ulogic;
    signal P2CMDEMPTY_out : std_ulogic;
    signal P2CMDFULL_out : std_ulogic;
    signal P2COUNT_out : std_logic_vector(6 downto 0);
    signal P2EMPTY_out : std_ulogic;
    signal P2ERROR_out : std_ulogic;
    signal P2FULL_out : std_ulogic;
    signal P2RDDATA_out : std_logic_vector(31 downto 0);
    signal P2RDOVERFLOW_out : std_ulogic;
    signal P2WRUNDERRUN_out : std_ulogic;
    signal P3CMDEMPTY_out : std_ulogic;
    signal P3CMDFULL_out : std_ulogic;
    signal P3COUNT_out : std_logic_vector(6 downto 0);
    signal P3EMPTY_out : std_ulogic;
    signal P3ERROR_out : std_ulogic;
    signal P3FULL_out : std_ulogic;
    signal P3RDDATA_out : std_logic_vector(31 downto 0);
    signal P3RDOVERFLOW_out : std_ulogic;
    signal P3WRUNDERRUN_out : std_ulogic;
    signal P4CMDEMPTY_out : std_ulogic;
    signal P4CMDFULL_out : std_ulogic;
    signal P4COUNT_out : std_logic_vector(6 downto 0);
    signal P4EMPTY_out : std_ulogic;
    signal P4ERROR_out : std_ulogic;
    signal P4FULL_out : std_ulogic;
    signal P4RDDATA_out : std_logic_vector(31 downto 0);
    signal P4RDOVERFLOW_out : std_ulogic;
    signal P4WRUNDERRUN_out : std_ulogic;
    signal P5CMDEMPTY_out : std_ulogic;
    signal P5CMDFULL_out : std_ulogic;
    signal P5COUNT_out : std_logic_vector(6 downto 0);
    signal P5EMPTY_out : std_ulogic;
    signal P5ERROR_out : std_ulogic;
    signal P5FULL_out : std_ulogic;
    signal P5RDDATA_out : std_logic_vector(31 downto 0);
    signal P5RDOVERFLOW_out : std_ulogic;
    signal P5WRUNDERRUN_out : std_ulogic;
    signal RAS_out : std_ulogic;
    signal RST_out : std_ulogic;
    signal SELFREFRESHMODE_out : std_ulogic;
    signal STATUS_out : std_logic_vector(31 downto 0);
    signal UDMN_out : std_ulogic;
    signal UDMP_out : std_ulogic;
    signal UOCALSTART_out : std_ulogic;
    signal UOCMDREADYIN_out : std_ulogic;
    signal UODATAVALID_out : std_ulogic;
    signal UODATA_out : std_logic_vector(7 downto 0);
    signal UODONECAL_out : std_ulogic;
    signal UOREFRSHFLAG_out : std_ulogic;
    signal UOSDO_out : std_ulogic;
    signal WE_out : std_ulogic;
    
    signal ADDR_outdelay : std_logic_vector(14 downto 0);
    signal BA_outdelay : std_logic_vector(2 downto 0);
    signal CAS_outdelay : std_ulogic;
    signal CKE_outdelay : std_ulogic;
    signal DQIOWEN0_outdelay : std_ulogic;
    signal DQON_outdelay : std_logic_vector(15 downto 0);
    signal DQOP_outdelay : std_logic_vector(15 downto 0);
    signal DQSIOWEN90N_outdelay : std_ulogic;
    signal DQSIOWEN90P_outdelay : std_ulogic;
    signal IOIDRPADDR_outdelay : std_logic_vector(4 downto 0);
    signal IOIDRPADD_outdelay : std_ulogic;
    signal IOIDRPBROADCAST_outdelay : std_ulogic;
    signal IOIDRPCLK_outdelay : std_ulogic;
    signal IOIDRPCS_outdelay : std_ulogic;
    signal IOIDRPSDO_outdelay : std_ulogic;
    signal IOIDRPTRAIN_outdelay : std_ulogic;
    signal IOIDRPUPDATE_outdelay : std_ulogic;
    signal LDMN_outdelay : std_ulogic;
    signal LDMP_outdelay : std_ulogic;
    signal ODT_outdelay : std_ulogic;
    signal P0CMDEMPTY_outdelay : std_ulogic;
    signal P0CMDFULL_outdelay : std_ulogic;
    signal P0RDCOUNT_outdelay : std_logic_vector(6 downto 0);
    signal P0RDDATA_outdelay : std_logic_vector(31 downto 0);
    signal P0RDEMPTY_outdelay : std_ulogic;
    signal P0RDERROR_outdelay : std_ulogic;
    signal P0RDFULL_outdelay : std_ulogic;
    signal P0RDOVERFLOW_outdelay : std_ulogic;
    signal P0WRCOUNT_outdelay : std_logic_vector(6 downto 0);
    signal P0WREMPTY_outdelay : std_ulogic;
    signal P0WRERROR_outdelay : std_ulogic;
    signal P0WRFULL_outdelay : std_ulogic;
    signal P0WRUNDERRUN_outdelay : std_ulogic;
    signal P1CMDEMPTY_outdelay : std_ulogic;
    signal P1CMDFULL_outdelay : std_ulogic;
    signal P1RDCOUNT_outdelay : std_logic_vector(6 downto 0);
    signal P1RDDATA_outdelay : std_logic_vector(31 downto 0);
    signal P1RDEMPTY_outdelay : std_ulogic;
    signal P1RDERROR_outdelay : std_ulogic;
    signal P1RDFULL_outdelay : std_ulogic;
    signal P1RDOVERFLOW_outdelay : std_ulogic;
    signal P1WRCOUNT_outdelay : std_logic_vector(6 downto 0);
    signal P1WREMPTY_outdelay : std_ulogic;
    signal P1WRERROR_outdelay : std_ulogic;
    signal P1WRFULL_outdelay : std_ulogic;
    signal P1WRUNDERRUN_outdelay : std_ulogic;
    signal P2CMDEMPTY_outdelay : std_ulogic;
    signal P2CMDFULL_outdelay : std_ulogic;
    signal P2COUNT_outdelay : std_logic_vector(6 downto 0);
    signal P2EMPTY_outdelay : std_ulogic;
    signal P2ERROR_outdelay : std_ulogic;
    signal P2FULL_outdelay : std_ulogic;
    signal P2RDDATA_outdelay : std_logic_vector(31 downto 0);
    signal P2RDOVERFLOW_outdelay : std_ulogic;
    signal P2WRUNDERRUN_outdelay : std_ulogic;
    signal P3CMDEMPTY_outdelay : std_ulogic;
    signal P3CMDFULL_outdelay : std_ulogic;
    signal P3COUNT_outdelay : std_logic_vector(6 downto 0);
    signal P3EMPTY_outdelay : std_ulogic;
    signal P3ERROR_outdelay : std_ulogic;
    signal P3FULL_outdelay : std_ulogic;
    signal P3RDDATA_outdelay : std_logic_vector(31 downto 0);
    signal P3RDOVERFLOW_outdelay : std_ulogic;
    signal P3WRUNDERRUN_outdelay : std_ulogic;
    signal P4CMDEMPTY_outdelay : std_ulogic;
    signal P4CMDFULL_outdelay : std_ulogic;
    signal P4COUNT_outdelay : std_logic_vector(6 downto 0);
    signal P4EMPTY_outdelay : std_ulogic;
    signal P4ERROR_outdelay : std_ulogic;
    signal P4FULL_outdelay : std_ulogic;
    signal P4RDDATA_outdelay : std_logic_vector(31 downto 0);
    signal P4RDOVERFLOW_outdelay : std_ulogic;
    signal P4WRUNDERRUN_outdelay : std_ulogic;
    signal P5CMDEMPTY_outdelay : std_ulogic;
    signal P5CMDFULL_outdelay : std_ulogic;
    signal P5COUNT_outdelay : std_logic_vector(6 downto 0);
    signal P5EMPTY_outdelay : std_ulogic;
    signal P5ERROR_outdelay : std_ulogic;
    signal P5FULL_outdelay : std_ulogic;
    signal P5RDDATA_outdelay : std_logic_vector(31 downto 0);
    signal P5RDOVERFLOW_outdelay : std_ulogic;
    signal P5WRUNDERRUN_outdelay : std_ulogic;
    signal RAS_outdelay : std_ulogic;
    signal RST_outdelay : std_ulogic;
    signal SELFREFRESHMODE_outdelay : std_ulogic;
    signal STATUS_outdelay : std_logic_vector(31 downto 0);
    signal UDMN_outdelay : std_ulogic;
    signal UDMP_outdelay : std_ulogic;
    signal UOCALSTART_outdelay : std_ulogic;
    signal UOCMDREADYIN_outdelay : std_ulogic;
    signal UODATAVALID_outdelay : std_ulogic;
    signal UODATA_outdelay : std_logic_vector(7 downto 0);
    signal UODONECAL_outdelay : std_ulogic;
    signal UOREFRSHFLAG_outdelay : std_ulogic;
    signal UOSDO_outdelay : std_ulogic;
    signal WE_outdelay : std_ulogic;
    
    signal DQI_ipd : std_logic_vector(15 downto 0);
    signal DQSIOIN_ipd : std_ulogic;
    signal DQSIOIP_ipd : std_ulogic;
    signal IOIDRPSDI_ipd : std_ulogic;
    signal P0ARBEN_ipd : std_ulogic;
    signal P0CMDBA_ipd : std_logic_vector(2 downto 0);
    signal P0CMDBL_ipd : std_logic_vector(5 downto 0);
    signal P0CMDCA_ipd : std_logic_vector(11 downto 0);
    signal P0CMDCLK_ipd : std_ulogic;
    signal P0CMDEN_ipd : std_ulogic;
    signal P0CMDINSTR_ipd : std_logic_vector(2 downto 0);
    signal P0CMDRA_ipd : std_logic_vector(14 downto 0);
    signal P0RDCLK_ipd : std_ulogic;
    signal P0RDEN_ipd : std_ulogic;
    signal P0RWRMASK_ipd : std_logic_vector(3 downto 0);
    signal P0WRCLK_ipd : std_ulogic;
    signal P0WRDATA_ipd : std_logic_vector(31 downto 0);
    signal P0WREN_ipd : std_ulogic;
    signal P1ARBEN_ipd : std_ulogic;
    signal P1CMDBA_ipd : std_logic_vector(2 downto 0);
    signal P1CMDBL_ipd : std_logic_vector(5 downto 0);
    signal P1CMDCA_ipd : std_logic_vector(11 downto 0);
    signal P1CMDCLK_ipd : std_ulogic;
    signal P1CMDEN_ipd : std_ulogic;
    signal P1CMDINSTR_ipd : std_logic_vector(2 downto 0);
    signal P1CMDRA_ipd : std_logic_vector(14 downto 0);
    signal P1RDCLK_ipd : std_ulogic;
    signal P1RDEN_ipd : std_ulogic;
    signal P1RWRMASK_ipd : std_logic_vector(3 downto 0);
    signal P1WRCLK_ipd : std_ulogic;
    signal P1WRDATA_ipd : std_logic_vector(31 downto 0);
    signal P1WREN_ipd : std_ulogic;
    signal P2ARBEN_ipd : std_ulogic;
    signal P2CLK_ipd : std_ulogic;
    signal P2CMDBA_ipd : std_logic_vector(2 downto 0);
    signal P2CMDBL_ipd : std_logic_vector(5 downto 0);
    signal P2CMDCA_ipd : std_logic_vector(11 downto 0);
    signal P2CMDCLK_ipd : std_ulogic;
    signal P2CMDEN_ipd : std_ulogic;
    signal P2CMDINSTR_ipd : std_logic_vector(2 downto 0);
    signal P2CMDRA_ipd : std_logic_vector(14 downto 0);
    signal P2EN_ipd : std_ulogic;
    signal P2WRDATA_ipd : std_logic_vector(31 downto 0);
    signal P2WRMASK_ipd : std_logic_vector(3 downto 0);
    signal P3ARBEN_ipd : std_ulogic;
    signal P3CLK_ipd : std_ulogic;
    signal P3CMDBA_ipd : std_logic_vector(2 downto 0);
    signal P3CMDBL_ipd : std_logic_vector(5 downto 0);
    signal P3CMDCA_ipd : std_logic_vector(11 downto 0);
    signal P3CMDCLK_ipd : std_ulogic;
    signal P3CMDEN_ipd : std_ulogic;
    signal P3CMDINSTR_ipd : std_logic_vector(2 downto 0);
    signal P3CMDRA_ipd : std_logic_vector(14 downto 0);
    signal P3EN_ipd : std_ulogic;
    signal P3WRDATA_ipd : std_logic_vector(31 downto 0);
    signal P3WRMASK_ipd : std_logic_vector(3 downto 0);
    signal P4ARBEN_ipd : std_ulogic;
    signal P4CLK_ipd : std_ulogic;
    signal P4CMDBA_ipd : std_logic_vector(2 downto 0);
    signal P4CMDBL_ipd : std_logic_vector(5 downto 0);
    signal P4CMDCA_ipd : std_logic_vector(11 downto 0);
    signal P4CMDCLK_ipd : std_ulogic;
    signal P4CMDEN_ipd : std_ulogic;
    signal P4CMDINSTR_ipd : std_logic_vector(2 downto 0);
    signal P4CMDRA_ipd : std_logic_vector(14 downto 0);
    signal P4EN_ipd : std_ulogic;
    signal P4WRDATA_ipd : std_logic_vector(31 downto 0);
    signal P4WRMASK_ipd : std_logic_vector(3 downto 0);
    signal P5ARBEN_ipd : std_ulogic;
    signal P5CLK_ipd : std_ulogic;
    signal P5CMDBA_ipd : std_logic_vector(2 downto 0);
    signal P5CMDBL_ipd : std_logic_vector(5 downto 0);
    signal P5CMDCA_ipd : std_logic_vector(11 downto 0);
    signal P5CMDCLK_ipd : std_ulogic;
    signal P5CMDEN_ipd : std_ulogic;
    signal P5CMDINSTR_ipd : std_logic_vector(2 downto 0);
    signal P5CMDRA_ipd : std_logic_vector(14 downto 0);
    signal P5EN_ipd : std_ulogic;
    signal P5WRDATA_ipd : std_logic_vector(31 downto 0);
    signal P5WRMASK_ipd : std_logic_vector(3 downto 0);
    signal PLLCE_ipd : std_logic_vector(1 downto 0);
    signal PLLCLK_ipd : std_logic_vector(1 downto 0);
    signal PLLLOCK_ipd : std_ulogic;
    signal RECAL_ipd : std_ulogic;
    signal SELFREFRESHENTER_ipd : std_ulogic;
    signal SYSRST_ipd : std_ulogic;
    signal UDQSIOIN_ipd : std_ulogic;
    signal UDQSIOIP_ipd : std_ulogic;
    signal UIADDR_ipd : std_logic_vector(4 downto 0);
    signal UIADD_ipd : std_ulogic;
    signal UIBROADCAST_ipd : std_ulogic;
    signal UICLK_ipd : std_ulogic;
    signal UICMDEN_ipd : std_ulogic;
    signal UICMDIN_ipd : std_ulogic;
    signal UICMD_ipd : std_ulogic;
    signal UICS_ipd : std_ulogic;
    signal UIDONECAL_ipd : std_ulogic;
    signal UIDQCOUNT_ipd : std_logic_vector(3 downto 0);
    signal UIDQLOWERDEC_ipd : std_ulogic;
    signal UIDQLOWERINC_ipd : std_ulogic;
    signal UIDQUPPERDEC_ipd : std_ulogic;
    signal UIDQUPPERINC_ipd : std_ulogic;
    signal UIDRPUPDATE_ipd : std_ulogic;
    signal UILDQSDEC_ipd : std_ulogic;
    signal UILDQSINC_ipd : std_ulogic;
    signal UIREAD_ipd : std_ulogic;
    signal UISDI_ipd : std_ulogic;
    signal UIUDQSDEC_ipd : std_ulogic;
    signal UIUDQSINC_ipd : std_ulogic;
    
    signal DQI_indelay : std_logic_vector(15 downto 0);
    signal DQSIOIN_indelay : std_ulogic;
    signal DQSIOIP_indelay : std_ulogic;
    signal IOIDRPSDI_indelay : std_ulogic;
    signal P0ARBEN_indelay : std_ulogic;
    signal P0CMDBA_indelay : std_logic_vector(2 downto 0);
    signal P0CMDBL_indelay : std_logic_vector(5 downto 0);
    signal P0CMDCA_indelay : std_logic_vector(11 downto 0);
    signal P0CMDCLK_indelay : std_ulogic;
    signal P0CMDEN_indelay : std_ulogic;
    signal P0CMDINSTR_indelay : std_logic_vector(2 downto 0);
    signal P0CMDRA_indelay : std_logic_vector(14 downto 0);
    signal P0RDCLK_indelay : std_ulogic;
    signal P0RDEN_indelay : std_ulogic;
    signal P0RWRMASK_indelay : std_logic_vector(3 downto 0);
    signal P0WRCLK_indelay : std_ulogic;
    signal P0WRDATA_indelay : std_logic_vector(31 downto 0);
    signal P0WREN_indelay : std_ulogic;
    signal P1ARBEN_indelay : std_ulogic;
    signal P1CMDBA_indelay : std_logic_vector(2 downto 0);
    signal P1CMDBL_indelay : std_logic_vector(5 downto 0);
    signal P1CMDCA_indelay : std_logic_vector(11 downto 0);
    signal P1CMDCLK_indelay : std_ulogic;
    signal P1CMDEN_indelay : std_ulogic;
    signal P1CMDINSTR_indelay : std_logic_vector(2 downto 0);
    signal P1CMDRA_indelay : std_logic_vector(14 downto 0);
    signal P1RDCLK_indelay : std_ulogic;
    signal P1RDEN_indelay : std_ulogic;
    signal P1RWRMASK_indelay : std_logic_vector(3 downto 0);
    signal P1WRCLK_indelay : std_ulogic;
    signal P1WRDATA_indelay : std_logic_vector(31 downto 0);
    signal P1WREN_indelay : std_ulogic;
    signal P2ARBEN_indelay : std_ulogic;
    signal P2CLK_indelay : std_ulogic;
    signal P2CMDBA_indelay : std_logic_vector(2 downto 0);
    signal P2CMDBL_indelay : std_logic_vector(5 downto 0);
    signal P2CMDCA_indelay : std_logic_vector(11 downto 0);
    signal P2CMDCLK_indelay : std_ulogic;
    signal P2CMDEN_indelay : std_ulogic;
    signal P2CMDINSTR_indelay : std_logic_vector(2 downto 0);
    signal P2CMDRA_indelay : std_logic_vector(14 downto 0);
    signal P2EN_indelay : std_ulogic;
    signal P2WRDATA_indelay : std_logic_vector(31 downto 0);
    signal P2WRMASK_indelay : std_logic_vector(3 downto 0);
    signal P3ARBEN_indelay : std_ulogic;
    signal P3CLK_indelay : std_ulogic;
    signal P3CMDBA_indelay : std_logic_vector(2 downto 0);
    signal P3CMDBL_indelay : std_logic_vector(5 downto 0);
    signal P3CMDCA_indelay : std_logic_vector(11 downto 0);
    signal P3CMDCLK_indelay : std_ulogic;
    signal P3CMDEN_indelay : std_ulogic;
    signal P3CMDINSTR_indelay : std_logic_vector(2 downto 0);
    signal P3CMDRA_indelay : std_logic_vector(14 downto 0);
    signal P3EN_indelay : std_ulogic;
    signal P3WRDATA_indelay : std_logic_vector(31 downto 0);
    signal P3WRMASK_indelay : std_logic_vector(3 downto 0);
    signal P4ARBEN_indelay : std_ulogic;
    signal P4CLK_indelay : std_ulogic;
    signal P4CMDBA_indelay : std_logic_vector(2 downto 0);
    signal P4CMDBL_indelay : std_logic_vector(5 downto 0);
    signal P4CMDCA_indelay : std_logic_vector(11 downto 0);
    signal P4CMDCLK_indelay : std_ulogic;
    signal P4CMDEN_indelay : std_ulogic;
    signal P4CMDINSTR_indelay : std_logic_vector(2 downto 0);
    signal P4CMDRA_indelay : std_logic_vector(14 downto 0);
    signal P4EN_indelay : std_ulogic;
    signal P4WRDATA_indelay : std_logic_vector(31 downto 0);
    signal P4WRMASK_indelay : std_logic_vector(3 downto 0);
    signal P5ARBEN_indelay : std_ulogic;
    signal P5CLK_indelay : std_ulogic;
    signal P5CMDBA_indelay : std_logic_vector(2 downto 0);
    signal P5CMDBL_indelay : std_logic_vector(5 downto 0);
    signal P5CMDCA_indelay : std_logic_vector(11 downto 0);
    signal P5CMDCLK_indelay : std_ulogic;
    signal P5CMDEN_indelay : std_ulogic;
    signal P5CMDINSTR_indelay : std_logic_vector(2 downto 0);
    signal P5CMDRA_indelay : std_logic_vector(14 downto 0);
    signal P5EN_indelay : std_ulogic;
    signal P5WRDATA_indelay : std_logic_vector(31 downto 0);
    signal P5WRMASK_indelay : std_logic_vector(3 downto 0);
    signal PLLCE_indelay : std_logic_vector(1 downto 0);
    signal PLLCLK_indelay : std_logic_vector(1 downto 0);
    signal PLLLOCK_indelay : std_ulogic;
    signal RECAL_indelay : std_ulogic;
    signal SELFREFRESHENTER_indelay : std_ulogic;
    signal SYSRST_indelay : std_ulogic;
    signal UDQSIOIN_indelay : std_ulogic;
    signal UDQSIOIP_indelay : std_ulogic;
    signal UIADDR_indelay : std_logic_vector(4 downto 0);
    signal UIADD_indelay : std_ulogic;
    signal UIBROADCAST_indelay : std_ulogic;
    signal UICLK_indelay : std_ulogic;
    signal UICMDEN_indelay : std_ulogic;
    signal UICMDIN_indelay : std_ulogic;
    signal UICMD_indelay : std_ulogic;
    signal UICS_indelay : std_ulogic;
    signal UIDONECAL_indelay : std_ulogic;
    signal UIDQCOUNT_indelay : std_logic_vector(3 downto 0);
    signal UIDQLOWERDEC_indelay : std_ulogic;
    signal UIDQLOWERINC_indelay : std_ulogic;
    signal UIDQUPPERDEC_indelay : std_ulogic;
    signal UIDQUPPERINC_indelay : std_ulogic;
    signal UIDRPUPDATE_indelay : std_ulogic;
    signal UILDQSDEC_indelay : std_ulogic;
    signal UILDQSINC_indelay : std_ulogic;
    signal UIREAD_indelay : std_ulogic;
    signal UISDI_indelay : std_ulogic;
    signal UIUDQSDEC_indelay : std_ulogic;
    signal UIUDQSINC_indelay : std_ulogic;

-- <!--Aldec correction start
	signal GSR_local : std_ulogic;
-- Aldec correction end -->
    
    begin
    ADDR_out <= ADDR_outdelay after OUT_DELAY;
    BA_out <= BA_outdelay after OUT_DELAY;
    CAS_out <= CAS_outdelay after OUT_DELAY;
    CKE_out <= CKE_outdelay after OUT_DELAY;
    DQIOWEN0_out <= DQIOWEN0_outdelay after OUT_DELAY;
    DQON_out <= DQON_outdelay after OUT_DELAY;
    DQOP_out <= DQOP_outdelay after OUT_DELAY;
    DQSIOWEN90N_out <= DQSIOWEN90N_outdelay after OUT_DELAY;
    DQSIOWEN90P_out <= DQSIOWEN90P_outdelay after OUT_DELAY;
    IOIDRPADDR_out <= IOIDRPADDR_outdelay after OUT_DELAY;
    IOIDRPADD_out <= IOIDRPADD_outdelay after OUT_DELAY;
    IOIDRPBROADCAST_out <= IOIDRPBROADCAST_outdelay after OUT_DELAY;
    IOIDRPCLK_out <= IOIDRPCLK_outdelay after OUT_DELAY;
    IOIDRPCS_out <= IOIDRPCS_outdelay after OUT_DELAY;
    IOIDRPSDO_out <= IOIDRPSDO_outdelay after OUT_DELAY;
    IOIDRPTRAIN_out <= IOIDRPTRAIN_outdelay after OUT_DELAY;
    IOIDRPUPDATE_out <= IOIDRPUPDATE_outdelay after OUT_DELAY;
    LDMN_out <= LDMN_outdelay after OUT_DELAY;
    LDMP_out <= LDMP_outdelay after OUT_DELAY;
    ODT_out <= ODT_outdelay after OUT_DELAY;
    P0CMDEMPTY_out <= P0CMDEMPTY_outdelay after OUT_DELAY;
    P0CMDFULL_out <= P0CMDFULL_outdelay after OUT_DELAY;
    P0RDCOUNT_out <= P0RDCOUNT_outdelay after OUT_DELAY;
    P0RDDATA_out <= P0RDDATA_outdelay after OUT_DELAY;
    P0RDEMPTY_out <= P0RDEMPTY_outdelay after OUT_DELAY;
    P0RDERROR_out <= P0RDERROR_outdelay after OUT_DELAY;
    P0RDFULL_out <= P0RDFULL_outdelay after OUT_DELAY;
    P0RDOVERFLOW_out <= P0RDOVERFLOW_outdelay after OUT_DELAY;
    P0WRCOUNT_out <= P0WRCOUNT_outdelay after OUT_DELAY;
    P0WREMPTY_out <= P0WREMPTY_outdelay after OUT_DELAY;
    P0WRERROR_out <= P0WRERROR_outdelay after OUT_DELAY;
    P0WRFULL_out <= P0WRFULL_outdelay after OUT_DELAY;
    P0WRUNDERRUN_out <= P0WRUNDERRUN_outdelay after OUT_DELAY;
    P1CMDEMPTY_out <= P1CMDEMPTY_outdelay after OUT_DELAY;
    P1CMDFULL_out <= P1CMDFULL_outdelay after OUT_DELAY;
    P1RDCOUNT_out <= P1RDCOUNT_outdelay after OUT_DELAY;
    P1RDDATA_out <= P1RDDATA_outdelay after OUT_DELAY;
    P1RDEMPTY_out <= P1RDEMPTY_outdelay after OUT_DELAY;
    P1RDERROR_out <= P1RDERROR_outdelay after OUT_DELAY;
    P1RDFULL_out <= P1RDFULL_outdelay after OUT_DELAY;
    P1RDOVERFLOW_out <= P1RDOVERFLOW_outdelay after OUT_DELAY;
    P1WRCOUNT_out <= P1WRCOUNT_outdelay after OUT_DELAY;
    P1WREMPTY_out <= P1WREMPTY_outdelay after OUT_DELAY;
    P1WRERROR_out <= P1WRERROR_outdelay after OUT_DELAY;
    P1WRFULL_out <= P1WRFULL_outdelay after OUT_DELAY;
    P1WRUNDERRUN_out <= P1WRUNDERRUN_outdelay after OUT_DELAY;
    P2CMDEMPTY_out <= P2CMDEMPTY_outdelay after OUT_DELAY;
    P2CMDFULL_out <= P2CMDFULL_outdelay after OUT_DELAY;
    P2COUNT_out <= P2COUNT_outdelay after OUT_DELAY;
    P2EMPTY_out <= P2EMPTY_outdelay after OUT_DELAY;
    P2ERROR_out <= P2ERROR_outdelay after OUT_DELAY;
    P2FULL_out <= P2FULL_outdelay after OUT_DELAY;
    P2RDDATA_out <= P2RDDATA_outdelay after OUT_DELAY;
    P2RDOVERFLOW_out <= P2RDOVERFLOW_outdelay after OUT_DELAY;
    P2WRUNDERRUN_out <= P2WRUNDERRUN_outdelay after OUT_DELAY;
    P3CMDEMPTY_out <= P3CMDEMPTY_outdelay after OUT_DELAY;
    P3CMDFULL_out <= P3CMDFULL_outdelay after OUT_DELAY;
    P3COUNT_out <= P3COUNT_outdelay after OUT_DELAY;
    P3EMPTY_out <= P3EMPTY_outdelay after OUT_DELAY;
    P3ERROR_out <= P3ERROR_outdelay after OUT_DELAY;
    P3FULL_out <= P3FULL_outdelay after OUT_DELAY;
    P3RDDATA_out <= P3RDDATA_outdelay after OUT_DELAY;
    P3RDOVERFLOW_out <= P3RDOVERFLOW_outdelay after OUT_DELAY;
    P3WRUNDERRUN_out <= P3WRUNDERRUN_outdelay after OUT_DELAY;
    P4CMDEMPTY_out <= P4CMDEMPTY_outdelay after OUT_DELAY;
    P4CMDFULL_out <= P4CMDFULL_outdelay after OUT_DELAY;
    P4COUNT_out <= P4COUNT_outdelay after OUT_DELAY;
    P4EMPTY_out <= P4EMPTY_outdelay after OUT_DELAY;
    P4ERROR_out <= P4ERROR_outdelay after OUT_DELAY;
    P4FULL_out <= P4FULL_outdelay after OUT_DELAY;
    P4RDDATA_out <= P4RDDATA_outdelay after OUT_DELAY;
    P4RDOVERFLOW_out <= P4RDOVERFLOW_outdelay after OUT_DELAY;
    P4WRUNDERRUN_out <= P4WRUNDERRUN_outdelay after OUT_DELAY;
    P5CMDEMPTY_out <= P5CMDEMPTY_outdelay after OUT_DELAY;
    P5CMDFULL_out <= P5CMDFULL_outdelay after OUT_DELAY;
    P5COUNT_out <= P5COUNT_outdelay after OUT_DELAY;
    P5EMPTY_out <= P5EMPTY_outdelay after OUT_DELAY;
    P5ERROR_out <= P5ERROR_outdelay after OUT_DELAY;
    P5FULL_out <= P5FULL_outdelay after OUT_DELAY;
    P5RDDATA_out <= P5RDDATA_outdelay after OUT_DELAY;
    P5RDOVERFLOW_out <= P5RDOVERFLOW_outdelay after OUT_DELAY;
    P5WRUNDERRUN_out <= P5WRUNDERRUN_outdelay after OUT_DELAY;
    RAS_out <= RAS_outdelay after OUT_DELAY;
    RST_out <= RST_outdelay after OUT_DELAY;
    SELFREFRESHMODE_out <= SELFREFRESHMODE_outdelay after OUT_DELAY;
    STATUS_out <= STATUS_outdelay after OUT_DELAY;
    UDMN_out <= UDMN_outdelay after OUT_DELAY;
    UDMP_out <= UDMP_outdelay after OUT_DELAY;
    UOCALSTART_out <= UOCALSTART_outdelay after OUT_DELAY;
    UOCMDREADYIN_out <= UOCMDREADYIN_outdelay after OUT_DELAY;
    UODATAVALID_out <= UODATAVALID_outdelay after OUT_DELAY;
    UODATA_out <= UODATA_outdelay after OUT_DELAY;
    UODONECAL_out <= UODONECAL_outdelay after OUT_DELAY;
    UOREFRSHFLAG_out <= UOREFRSHFLAG_outdelay after OUT_DELAY;
    UOSDO_out <= UOSDO_outdelay after OUT_DELAY;
    WE_out <= WE_outdelay after OUT_DELAY;
    
    DQSIOIN_ipd <= DQSIOIN;
    DQSIOIP_ipd <= DQSIOIP;
    P0CMDCLK_ipd <= P0CMDCLK;
    P0RDCLK_ipd <= P0RDCLK;
    P0WRCLK_ipd <= P0WRCLK;
    P1CMDCLK_ipd <= P1CMDCLK;
    P1RDCLK_ipd <= P1RDCLK;
    P1WRCLK_ipd <= P1WRCLK;
    P2CLK_ipd <= P2CLK;
    P2CMDCLK_ipd <= P2CMDCLK;
    P3CLK_ipd <= P3CLK;
    P3CMDCLK_ipd <= P3CMDCLK;
    P4CLK_ipd <= P4CLK;
    P4CMDCLK_ipd <= P4CMDCLK;
    P5CLK_ipd <= P5CLK;
    P5CMDCLK_ipd <= P5CMDCLK;
    PLLCLK_ipd <= PLLCLK;
    UDQSIOIN_ipd <= UDQSIOIN;
    UDQSIOIP_ipd <= UDQSIOIP;
    UICLK_ipd <= UICLK;
    
    DQI_ipd <= DQI;
    IOIDRPSDI_ipd <= IOIDRPSDI;
    P0ARBEN_ipd <= P0ARBEN;
    P0CMDBA_ipd <= P0CMDBA;
    P0CMDBL_ipd <= P0CMDBL;
    P0CMDCA_ipd <= P0CMDCA;
    P0CMDEN_ipd <= P0CMDEN;
    P0CMDINSTR_ipd <= P0CMDINSTR;
    P0CMDRA_ipd <= P0CMDRA;
    P0RDEN_ipd <= P0RDEN;
    P0RWRMASK_ipd <= P0RWRMASK;
    P0WRDATA_ipd <= P0WRDATA;
    P0WREN_ipd <= P0WREN;
    P1ARBEN_ipd <= P1ARBEN;
    P1CMDBA_ipd <= P1CMDBA;
    P1CMDBL_ipd <= P1CMDBL;
    P1CMDCA_ipd <= P1CMDCA;
    P1CMDEN_ipd <= P1CMDEN;
    P1CMDINSTR_ipd <= P1CMDINSTR;
    P1CMDRA_ipd <= P1CMDRA;
    P1RDEN_ipd <= P1RDEN;
    P1RWRMASK_ipd <= P1RWRMASK;
    P1WRDATA_ipd <= P1WRDATA;
    P1WREN_ipd <= P1WREN;
    P2ARBEN_ipd <= P2ARBEN;
    P2CMDBA_ipd <= P2CMDBA;
    P2CMDBL_ipd <= P2CMDBL;
    P2CMDCA_ipd <= P2CMDCA;
    P2CMDEN_ipd <= P2CMDEN;
    P2CMDINSTR_ipd <= P2CMDINSTR;
    P2CMDRA_ipd <= P2CMDRA;
    P2EN_ipd <= P2EN;
    P2WRDATA_ipd <= P2WRDATA;
    P2WRMASK_ipd <= P2WRMASK;
    P3ARBEN_ipd <= P3ARBEN;
    P3CMDBA_ipd <= P3CMDBA;
    P3CMDBL_ipd <= P3CMDBL;
    P3CMDCA_ipd <= P3CMDCA;
    P3CMDEN_ipd <= P3CMDEN;
    P3CMDINSTR_ipd <= P3CMDINSTR;
    P3CMDRA_ipd <= P3CMDRA;
    P3EN_ipd <= P3EN;
    P3WRDATA_ipd <= P3WRDATA;
    P3WRMASK_ipd <= P3WRMASK;
    P4ARBEN_ipd <= P4ARBEN;
    P4CMDBA_ipd <= P4CMDBA;
    P4CMDBL_ipd <= P4CMDBL;
    P4CMDCA_ipd <= P4CMDCA;
    P4CMDEN_ipd <= P4CMDEN;
    P4CMDINSTR_ipd <= P4CMDINSTR;
    P4CMDRA_ipd <= P4CMDRA;
    P4EN_ipd <= P4EN;
    P4WRDATA_ipd <= P4WRDATA;
    P4WRMASK_ipd <= P4WRMASK;
    P5ARBEN_ipd <= P5ARBEN;
    P5CMDBA_ipd <= P5CMDBA;
    P5CMDBL_ipd <= P5CMDBL;
    P5CMDCA_ipd <= P5CMDCA;
    P5CMDEN_ipd <= P5CMDEN;
    P5CMDINSTR_ipd <= P5CMDINSTR;
    P5CMDRA_ipd <= P5CMDRA;
    P5EN_ipd <= P5EN;
    P5WRDATA_ipd <= P5WRDATA;
    P5WRMASK_ipd <= P5WRMASK;
    PLLCE_ipd <= PLLCE;
    PLLLOCK_ipd <= PLLLOCK;
    RECAL_ipd <= RECAL;
    SELFREFRESHENTER_ipd <= SELFREFRESHENTER;
    SYSRST_ipd <= SYSRST;
    UIADDR_ipd <= UIADDR;
    UIADD_ipd <= UIADD;
    UIBROADCAST_ipd <= UIBROADCAST;
    UICMDEN_ipd <= UICMDEN;
    UICMDIN_ipd <= UICMDIN;
    UICMD_ipd <= UICMD;
    UICS_ipd <= UICS;
    UIDONECAL_ipd <= UIDONECAL;
    UIDQCOUNT_ipd <= UIDQCOUNT;
    UIDQLOWERDEC_ipd <= UIDQLOWERDEC;
    UIDQLOWERINC_ipd <= UIDQLOWERINC;
    UIDQUPPERDEC_ipd <= UIDQUPPERDEC;
    UIDQUPPERINC_ipd <= UIDQUPPERINC;
    UIDRPUPDATE_ipd <= UIDRPUPDATE;
    UILDQSDEC_ipd <= UILDQSDEC;
    UILDQSINC_ipd <= UILDQSINC;
    UIREAD_ipd <= UIREAD;
    UISDI_ipd <= UISDI;
    UIUDQSDEC_ipd <= UIUDQSDEC;
    UIUDQSINC_ipd <= UIUDQSINC;
    
    DQSIOIN_indelay <= DQSIOIN_ipd after INCLK_DELAY;
    DQSIOIP_indelay <= DQSIOIP_ipd after INCLK_DELAY;
    P0CMDCLK_indelay <= P0CMDCLK_ipd after INCLK_DELAY;
    P0RDCLK_indelay <= P0RDCLK_ipd after INCLK_DELAY;
    P0WRCLK_indelay <= P0WRCLK_ipd after INCLK_DELAY;
    P1CMDCLK_indelay <= P1CMDCLK_ipd after INCLK_DELAY;
    P1RDCLK_indelay <= P1RDCLK_ipd after INCLK_DELAY;
    P1WRCLK_indelay <= P1WRCLK_ipd after INCLK_DELAY;
    P2CLK_indelay <= P2CLK_ipd after INCLK_DELAY;
    P2CMDCLK_indelay <= P2CMDCLK_ipd after INCLK_DELAY;
    P3CLK_indelay <= P3CLK_ipd after INCLK_DELAY;
    P3CMDCLK_indelay <= P3CMDCLK_ipd after INCLK_DELAY;
    P4CLK_indelay <= P4CLK_ipd after INCLK_DELAY;
    P4CMDCLK_indelay <= P4CMDCLK_ipd after INCLK_DELAY;
    P5CLK_indelay <= P5CLK_ipd after INCLK_DELAY;
    P5CMDCLK_indelay <= P5CMDCLK_ipd after INCLK_DELAY;
    PLLCLK_indelay <= PLLCLK_ipd after INCLK_DELAY;
    UDQSIOIN_indelay <= UDQSIOIN_ipd after INCLK_DELAY;
    UDQSIOIP_indelay <= UDQSIOIP_ipd after INCLK_DELAY;
    UICLK_indelay <= UICLK_ipd after INCLK_DELAY;
    
    DQI_indelay <= DQI_ipd after IN_DELAY;
    IOIDRPSDI_indelay <= IOIDRPSDI_ipd after IN_DELAY;
    P0ARBEN_indelay <= P0ARBEN_ipd after IN_DELAY;
    P0CMDBA_indelay <= P0CMDBA_ipd after IN_DELAY;
    P0CMDBL_indelay <= P0CMDBL_ipd after IN_DELAY;
    P0CMDCA_indelay <= P0CMDCA_ipd after IN_DELAY;
    P0CMDEN_indelay <= P0CMDEN_ipd after IN_DELAY;
    P0CMDINSTR_indelay <= P0CMDINSTR_ipd after IN_DELAY;
    P0CMDRA_indelay <= P0CMDRA_ipd after IN_DELAY;
    P0RDEN_indelay <= P0RDEN_ipd after IN_DELAY;
    P0RWRMASK_indelay <= P0RWRMASK_ipd after IN_DELAY;
    P0WRDATA_indelay <= P0WRDATA_ipd after IN_DELAY;
    P0WREN_indelay <= P0WREN_ipd after IN_DELAY;
    P1ARBEN_indelay <= P1ARBEN_ipd after IN_DELAY;
    P1CMDBA_indelay <= P1CMDBA_ipd after IN_DELAY;
    P1CMDBL_indelay <= P1CMDBL_ipd after IN_DELAY;
    P1CMDCA_indelay <= P1CMDCA_ipd after IN_DELAY;
    P1CMDEN_indelay <= P1CMDEN_ipd after IN_DELAY;
    P1CMDINSTR_indelay <= P1CMDINSTR_ipd after IN_DELAY;
    P1CMDRA_indelay <= P1CMDRA_ipd after IN_DELAY;
    P1RDEN_indelay <= P1RDEN_ipd after IN_DELAY;
    P1RWRMASK_indelay <= P1RWRMASK_ipd after IN_DELAY;
    P1WRDATA_indelay <= P1WRDATA_ipd after IN_DELAY;
    P1WREN_indelay <= P1WREN_ipd after IN_DELAY;
    P2ARBEN_indelay <= P2ARBEN_ipd after IN_DELAY;
    P2CMDBA_indelay <= P2CMDBA_ipd after IN_DELAY;
    P2CMDBL_indelay <= P2CMDBL_ipd after IN_DELAY;
    P2CMDCA_indelay <= P2CMDCA_ipd after IN_DELAY;
    P2CMDEN_indelay <= P2CMDEN_ipd after IN_DELAY;
    P2CMDINSTR_indelay <= P2CMDINSTR_ipd after IN_DELAY;
    P2CMDRA_indelay <= P2CMDRA_ipd after IN_DELAY;
    P2EN_indelay <= P2EN_ipd after IN_DELAY;
    P2WRDATA_indelay <= P2WRDATA_ipd after IN_DELAY;
    P2WRMASK_indelay <= P2WRMASK_ipd after IN_DELAY;
    P3ARBEN_indelay <= P3ARBEN_ipd after IN_DELAY;
    P3CMDBA_indelay <= P3CMDBA_ipd after IN_DELAY;
    P3CMDBL_indelay <= P3CMDBL_ipd after IN_DELAY;
    P3CMDCA_indelay <= P3CMDCA_ipd after IN_DELAY;
    P3CMDEN_indelay <= P3CMDEN_ipd after IN_DELAY;
    P3CMDINSTR_indelay <= P3CMDINSTR_ipd after IN_DELAY;
    P3CMDRA_indelay <= P3CMDRA_ipd after IN_DELAY;
    P3EN_indelay <= P3EN_ipd after IN_DELAY;
    P3WRDATA_indelay <= P3WRDATA_ipd after IN_DELAY;
    P3WRMASK_indelay <= P3WRMASK_ipd after IN_DELAY;
    P4ARBEN_indelay <= P4ARBEN_ipd after IN_DELAY;
    P4CMDBA_indelay <= P4CMDBA_ipd after IN_DELAY;
    P4CMDBL_indelay <= P4CMDBL_ipd after IN_DELAY;
    P4CMDCA_indelay <= P4CMDCA_ipd after IN_DELAY;
    P4CMDEN_indelay <= P4CMDEN_ipd after IN_DELAY;
    P4CMDINSTR_indelay <= P4CMDINSTR_ipd after IN_DELAY;
    P4CMDRA_indelay <= P4CMDRA_ipd after IN_DELAY;
    P4EN_indelay <= P4EN_ipd after IN_DELAY;
    P4WRDATA_indelay <= P4WRDATA_ipd after IN_DELAY;
    P4WRMASK_indelay <= P4WRMASK_ipd after IN_DELAY;
    P5ARBEN_indelay <= P5ARBEN_ipd after IN_DELAY;
    P5CMDBA_indelay <= P5CMDBA_ipd after IN_DELAY;
    P5CMDBL_indelay <= P5CMDBL_ipd after IN_DELAY;
    P5CMDCA_indelay <= P5CMDCA_ipd after IN_DELAY;
    P5CMDEN_indelay <= P5CMDEN_ipd after IN_DELAY;
    P5CMDINSTR_indelay <= P5CMDINSTR_ipd after IN_DELAY;
    P5CMDRA_indelay <= P5CMDRA_ipd after IN_DELAY;
    P5EN_indelay <= P5EN_ipd after IN_DELAY;
    P5WRDATA_indelay <= P5WRDATA_ipd after IN_DELAY;
    P5WRMASK_indelay <= P5WRMASK_ipd after IN_DELAY;
    PLLCE_indelay <= PLLCE_ipd after IN_DELAY;
    PLLLOCK_indelay <= PLLLOCK_ipd after IN_DELAY;
    RECAL_indelay <= RECAL_ipd after IN_DELAY;
    SELFREFRESHENTER_indelay <= SELFREFRESHENTER_ipd after IN_DELAY;
    SYSRST_indelay <= SYSRST_ipd after IN_DELAY;
    UIADDR_indelay <= UIADDR_ipd after IN_DELAY;
    UIADD_indelay <= UIADD_ipd after IN_DELAY;
    UIBROADCAST_indelay <= UIBROADCAST_ipd after IN_DELAY;
    UICMDEN_indelay <= UICMDEN_ipd after IN_DELAY;
    UICMDIN_indelay <= UICMDIN_ipd after IN_DELAY;
    UICMD_indelay <= UICMD_ipd after IN_DELAY;
    UICS_indelay <= UICS_ipd after IN_DELAY;
    UIDONECAL_indelay <= UIDONECAL_ipd after IN_DELAY;
    UIDQCOUNT_indelay <= UIDQCOUNT_ipd after IN_DELAY;
    UIDQLOWERDEC_indelay <= UIDQLOWERDEC_ipd after IN_DELAY;
    UIDQLOWERINC_indelay <= UIDQLOWERINC_ipd after IN_DELAY;
    UIDQUPPERDEC_indelay <= UIDQUPPERDEC_ipd after IN_DELAY;
    UIDQUPPERINC_indelay <= UIDQUPPERINC_ipd after IN_DELAY;
    UIDRPUPDATE_indelay <= UIDRPUPDATE_ipd after IN_DELAY;
    UILDQSDEC_indelay <= UILDQSDEC_ipd after IN_DELAY;
    UILDQSINC_indelay <= UILDQSINC_ipd after IN_DELAY;
    UIREAD_indelay <= UIREAD_ipd after IN_DELAY;
    UISDI_indelay <= UISDI_ipd after IN_DELAY;
    UIUDQSDEC_indelay <= UIUDQSDEC_ipd after IN_DELAY;
    UIUDQSINC_indelay <= UIUDQSINC_ipd after IN_DELAY;
    
-- <!--Aldec correction start
	GSR_local <= GSR;
-- Aldec correction end -->
    
    MCB_INST : MCB_WRAP
      generic map (
        ARB_NUM_TIME_SLOTS   => ARB_NUM_TIME_SLOTS,
        ARB_TIME_SLOT_0      => ARB_TIME_SLOT_0_STRING,
        ARB_TIME_SLOT_1      => ARB_TIME_SLOT_1_STRING,
        ARB_TIME_SLOT_10     => ARB_TIME_SLOT_10_STRING,
        ARB_TIME_SLOT_11     => ARB_TIME_SLOT_11_STRING,
        ARB_TIME_SLOT_2      => ARB_TIME_SLOT_2_STRING,
        ARB_TIME_SLOT_3      => ARB_TIME_SLOT_3_STRING,
        ARB_TIME_SLOT_4      => ARB_TIME_SLOT_4_STRING,
        ARB_TIME_SLOT_5      => ARB_TIME_SLOT_5_STRING,
        ARB_TIME_SLOT_6      => ARB_TIME_SLOT_6_STRING,
        ARB_TIME_SLOT_7      => ARB_TIME_SLOT_7_STRING,
        ARB_TIME_SLOT_8      => ARB_TIME_SLOT_8_STRING,
        ARB_TIME_SLOT_9      => ARB_TIME_SLOT_9_STRING,
        CAL_BA               => CAL_BA_STRING,
        CAL_BYPASS           => CAL_BYPASS,
        CAL_CA               => CAL_CA_STRING,
        CAL_CALIBRATION_MODE => CAL_CALIBRATION_MODE,
        CAL_CLK_DIV          => CAL_CLK_DIV,
        CAL_DELAY            => CAL_DELAY,
        CAL_RA               => CAL_RA_STRING,
        MEM_ADDR_ORDER       => MEM_ADDR_ORDER,
        MEM_BA_SIZE          => MEM_BA_SIZE,
        MEM_BURST_LEN        => MEM_BURST_LEN,
        MEM_CAS_LATENCY      => MEM_CAS_LATENCY,
        MEM_CA_SIZE          => MEM_CA_SIZE,
        MEM_DDR1_2_ODS       => MEM_DDR1_2_ODS,
        MEM_DDR2_3_HIGH_TEMP_SR => MEM_DDR2_3_HIGH_TEMP_SR,
        MEM_DDR2_3_PA_SR     => MEM_DDR2_3_PA_SR,
        MEM_DDR2_ADD_LATENCY => MEM_DDR2_ADD_LATENCY,
        MEM_DDR2_DIFF_DQS_EN => MEM_DDR2_DIFF_DQS_EN,
        MEM_DDR2_RTT         => MEM_DDR2_RTT,
        MEM_DDR2_WRT_RECOVERY => MEM_DDR2_WRT_RECOVERY,
        MEM_DDR3_ADD_LATENCY => MEM_DDR3_ADD_LATENCY,
        MEM_DDR3_AUTO_SR     => MEM_DDR3_AUTO_SR,
        MEM_DDR3_CAS_LATENCY => MEM_DDR3_CAS_LATENCY,
        MEM_DDR3_CAS_WR_LATENCY => MEM_DDR3_CAS_WR_LATENCY,
        MEM_DDR3_DYN_WRT_ODT => MEM_DDR3_DYN_WRT_ODT,
        MEM_DDR3_ODS         => MEM_DDR3_ODS,
        MEM_DDR3_RTT         => MEM_DDR3_RTT,
        MEM_DDR3_WRT_RECOVERY => MEM_DDR3_WRT_RECOVERY,
        MEM_MDDR_ODS         => MEM_MDDR_ODS,
        MEM_MOBILE_PA_SR     => MEM_MOBILE_PA_SR,
        MEM_MOBILE_TC_SR     => MEM_MOBILE_TC_SR,
        MEM_RAS_VAL          => MEM_RAS_VAL,
        MEM_RA_SIZE          => MEM_RA_SIZE,
        MEM_RCD_VAL          => MEM_RCD_VAL,
        MEM_REFI_VAL         => MEM_REFI_VAL,
        MEM_RFC_VAL          => MEM_RFC_VAL,
        MEM_RP_VAL           => MEM_RP_VAL,
        MEM_RTP_VAL          => MEM_RTP_VAL,
        MEM_TYPE             => MEM_TYPE,
        MEM_WIDTH            => MEM_WIDTH,
        MEM_WR_VAL           => MEM_WR_VAL,
        MEM_WTR_VAL          => MEM_WTR_VAL,
        PORT_CONFIG          => PORT_CONFIG
      )
      
      port map (
        ADDR                 => ADDR_outdelay,
        BA                   => BA_outdelay,
        CAS                  => CAS_outdelay,
        CKE                  => CKE_outdelay,
        DQIOWEN0             => DQIOWEN0_outdelay,
        DQON                 => DQON_outdelay,
        DQOP                 => DQOP_outdelay,
        DQSIOWEN90N          => DQSIOWEN90N_outdelay,
        DQSIOWEN90P          => DQSIOWEN90P_outdelay,
        IOIDRPADD            => IOIDRPADD_outdelay,
        IOIDRPADDR           => IOIDRPADDR_outdelay,
        IOIDRPBROADCAST      => IOIDRPBROADCAST_outdelay,
        IOIDRPCLK            => IOIDRPCLK_outdelay,
        IOIDRPCS             => IOIDRPCS_outdelay,
        IOIDRPSDO            => IOIDRPSDO_outdelay,
        IOIDRPTRAIN          => IOIDRPTRAIN_outdelay,
        IOIDRPUPDATE         => IOIDRPUPDATE_outdelay,
        LDMN                 => LDMN_outdelay,
        LDMP                 => LDMP_outdelay,
        ODT                  => ODT_outdelay,
        P0CMDEMPTY           => P0CMDEMPTY_outdelay,
        P0CMDFULL            => P0CMDFULL_outdelay,
        P0RDCOUNT            => P0RDCOUNT_outdelay,
        P0RDDATA             => P0RDDATA_outdelay,
        P0RDEMPTY            => P0RDEMPTY_outdelay,
        P0RDERROR            => P0RDERROR_outdelay,
        P0RDFULL             => P0RDFULL_outdelay,
        P0RDOVERFLOW         => P0RDOVERFLOW_outdelay,
        P0WRCOUNT            => P0WRCOUNT_outdelay,
        P0WREMPTY            => P0WREMPTY_outdelay,
        P0WRERROR            => P0WRERROR_outdelay,
        P0WRFULL             => P0WRFULL_outdelay,
        P0WRUNDERRUN         => P0WRUNDERRUN_outdelay,
        P1CMDEMPTY           => P1CMDEMPTY_outdelay,
        P1CMDFULL            => P1CMDFULL_outdelay,
        P1RDCOUNT            => P1RDCOUNT_outdelay,
        P1RDDATA             => P1RDDATA_outdelay,
        P1RDEMPTY            => P1RDEMPTY_outdelay,
        P1RDERROR            => P1RDERROR_outdelay,
        P1RDFULL             => P1RDFULL_outdelay,
        P1RDOVERFLOW         => P1RDOVERFLOW_outdelay,
        P1WRCOUNT            => P1WRCOUNT_outdelay,
        P1WREMPTY            => P1WREMPTY_outdelay,
        P1WRERROR            => P1WRERROR_outdelay,
        P1WRFULL             => P1WRFULL_outdelay,
        P1WRUNDERRUN         => P1WRUNDERRUN_outdelay,
        P2CMDEMPTY           => P2CMDEMPTY_outdelay,
        P2CMDFULL            => P2CMDFULL_outdelay,
        P2COUNT              => P2COUNT_outdelay,
        P2EMPTY              => P2EMPTY_outdelay,
        P2ERROR              => P2ERROR_outdelay,
        P2FULL               => P2FULL_outdelay,
        P2RDDATA             => P2RDDATA_outdelay,
        P2RDOVERFLOW         => P2RDOVERFLOW_outdelay,
        P2WRUNDERRUN         => P2WRUNDERRUN_outdelay,
        P3CMDEMPTY           => P3CMDEMPTY_outdelay,
        P3CMDFULL            => P3CMDFULL_outdelay,
        P3COUNT              => P3COUNT_outdelay,
        P3EMPTY              => P3EMPTY_outdelay,
        P3ERROR              => P3ERROR_outdelay,
        P3FULL               => P3FULL_outdelay,
        P3RDDATA             => P3RDDATA_outdelay,
        P3RDOVERFLOW         => P3RDOVERFLOW_outdelay,
        P3WRUNDERRUN         => P3WRUNDERRUN_outdelay,
        P4CMDEMPTY           => P4CMDEMPTY_outdelay,
        P4CMDFULL            => P4CMDFULL_outdelay,
        P4COUNT              => P4COUNT_outdelay,
        P4EMPTY              => P4EMPTY_outdelay,
        P4ERROR              => P4ERROR_outdelay,
        P4FULL               => P4FULL_outdelay,
        P4RDDATA             => P4RDDATA_outdelay,
        P4RDOVERFLOW         => P4RDOVERFLOW_outdelay,
        P4WRUNDERRUN         => P4WRUNDERRUN_outdelay,
        P5CMDEMPTY           => P5CMDEMPTY_outdelay,
        P5CMDFULL            => P5CMDFULL_outdelay,
        P5COUNT              => P5COUNT_outdelay,
        P5EMPTY              => P5EMPTY_outdelay,
        P5ERROR              => P5ERROR_outdelay,
        P5FULL               => P5FULL_outdelay,
        P5RDDATA             => P5RDDATA_outdelay,
        P5RDOVERFLOW         => P5RDOVERFLOW_outdelay,
        P5WRUNDERRUN         => P5WRUNDERRUN_outdelay,
        RAS                  => RAS_outdelay,
        RST                  => RST_outdelay,
        SELFREFRESHMODE      => SELFREFRESHMODE_outdelay,
        STATUS               => STATUS_outdelay,
        UDMN                 => UDMN_outdelay,
        UDMP                 => UDMP_outdelay,
        UOCALSTART           => UOCALSTART_outdelay,
        UOCMDREADYIN         => UOCMDREADYIN_outdelay,
        UODATA               => UODATA_outdelay,
        UODATAVALID          => UODATAVALID_outdelay,
        UODONECAL            => UODONECAL_outdelay,
        UOREFRSHFLAG         => UOREFRSHFLAG_outdelay,
        UOSDO                => UOSDO_outdelay,
        WE                   => WE_outdelay,
        DQI                  => DQI_indelay,
        DQSIOIN              => DQSIOIN_indelay,
        DQSIOIP              => DQSIOIP_indelay,
        IOIDRPSDI            => IOIDRPSDI_indelay,
        P0ARBEN              => P0ARBEN_indelay,
        P0CMDBA              => P0CMDBA_indelay,
        P0CMDBL              => P0CMDBL_indelay,
        P0CMDCA              => P0CMDCA_indelay,
        P0CMDCLK             => P0CMDCLK_indelay,
        P0CMDEN              => P0CMDEN_indelay,
        P0CMDINSTR           => P0CMDINSTR_indelay,
        P0CMDRA              => P0CMDRA_indelay,
        P0RDCLK              => P0RDCLK_indelay,
        P0RDEN               => P0RDEN_indelay,
        P0RWRMASK            => P0RWRMASK_indelay,
        P0WRCLK              => P0WRCLK_indelay,
        P0WRDATA             => P0WRDATA_indelay,
        P0WREN               => P0WREN_indelay,
        P1ARBEN              => P1ARBEN_indelay,
        P1CMDBA              => P1CMDBA_indelay,
        P1CMDBL              => P1CMDBL_indelay,
        P1CMDCA              => P1CMDCA_indelay,
        P1CMDCLK             => P1CMDCLK_indelay,
        P1CMDEN              => P1CMDEN_indelay,
        P1CMDINSTR           => P1CMDINSTR_indelay,
        P1CMDRA              => P1CMDRA_indelay,
        P1RDCLK              => P1RDCLK_indelay,
        P1RDEN               => P1RDEN_indelay,
        P1RWRMASK            => P1RWRMASK_indelay,
        P1WRCLK              => P1WRCLK_indelay,
        P1WRDATA             => P1WRDATA_indelay,
        P1WREN               => P1WREN_indelay,
        P2ARBEN              => P2ARBEN_indelay,
        P2CLK                => P2CLK_indelay,
        P2CMDBA              => P2CMDBA_indelay,
        P2CMDBL              => P2CMDBL_indelay,
        P2CMDCA              => P2CMDCA_indelay,
        P2CMDCLK             => P2CMDCLK_indelay,
        P2CMDEN              => P2CMDEN_indelay,
        P2CMDINSTR           => P2CMDINSTR_indelay,
        P2CMDRA              => P2CMDRA_indelay,
        P2EN                 => P2EN_indelay,
        P2WRDATA             => P2WRDATA_indelay,
        P2WRMASK             => P2WRMASK_indelay,
        P3ARBEN              => P3ARBEN_indelay,
        P3CLK                => P3CLK_indelay,
        P3CMDBA              => P3CMDBA_indelay,
        P3CMDBL              => P3CMDBL_indelay,
        P3CMDCA              => P3CMDCA_indelay,
        P3CMDCLK             => P3CMDCLK_indelay,
        P3CMDEN              => P3CMDEN_indelay,
        P3CMDINSTR           => P3CMDINSTR_indelay,
        P3CMDRA              => P3CMDRA_indelay,
        P3EN                 => P3EN_indelay,
        P3WRDATA             => P3WRDATA_indelay,
        P3WRMASK             => P3WRMASK_indelay,
        P4ARBEN              => P4ARBEN_indelay,
        P4CLK                => P4CLK_indelay,
        P4CMDBA              => P4CMDBA_indelay,
        P4CMDBL              => P4CMDBL_indelay,
        P4CMDCA              => P4CMDCA_indelay,
        P4CMDCLK             => P4CMDCLK_indelay,
        P4CMDEN              => P4CMDEN_indelay,
        P4CMDINSTR           => P4CMDINSTR_indelay,
        P4CMDRA              => P4CMDRA_indelay,
        P4EN                 => P4EN_indelay,
        P4WRDATA             => P4WRDATA_indelay,
        P4WRMASK             => P4WRMASK_indelay,
        P5ARBEN              => P5ARBEN_indelay,
        P5CLK                => P5CLK_indelay,
        P5CMDBA              => P5CMDBA_indelay,
        P5CMDBL              => P5CMDBL_indelay,
        P5CMDCA              => P5CMDCA_indelay,
        P5CMDCLK             => P5CMDCLK_indelay,
        P5CMDEN              => P5CMDEN_indelay,
        P5CMDINSTR           => P5CMDINSTR_indelay,
        P5CMDRA              => P5CMDRA_indelay,
        P5EN                 => P5EN_indelay,
        P5WRDATA             => P5WRDATA_indelay,
        P5WRMASK             => P5WRMASK_indelay,
        PLLCE                => PLLCE_indelay,
        PLLCLK               => PLLCLK_indelay,
        PLLLOCK              => PLLLOCK_indelay,
        RECAL                => RECAL_indelay,
        SELFREFRESHENTER     => SELFREFRESHENTER_indelay,
        SYSRST               => SYSRST_indelay,
        UDQSIOIN             => UDQSIOIN_indelay,
        UDQSIOIP             => UDQSIOIP_indelay,
        UIADD                => UIADD_indelay,
        UIADDR               => UIADDR_indelay,
        UIBROADCAST          => UIBROADCAST_indelay,
        UICLK                => UICLK_indelay,
        UICMD                => UICMD_indelay,
        UICMDEN              => UICMDEN_indelay,
        UICMDIN              => UICMDIN_indelay,
        UICS                 => UICS_indelay,
        UIDONECAL            => UIDONECAL_indelay,
        UIDQCOUNT            => UIDQCOUNT_indelay,
        UIDQLOWERDEC         => UIDQLOWERDEC_indelay,
        UIDQLOWERINC         => UIDQLOWERINC_indelay,
        UIDQUPPERDEC         => UIDQUPPERDEC_indelay,
        UIDQUPPERINC         => UIDQUPPERINC_indelay,
        UIDRPUPDATE          => UIDRPUPDATE_indelay,
        UILDQSDEC            => UILDQSDEC_indelay,
        UILDQSINC            => UILDQSINC_indelay,
        UIREAD               => UIREAD_indelay,
        UISDI                => UISDI_indelay,
        UIUDQSDEC            => UIUDQSDEC_indelay,
        UIUDQSINC            => UIUDQSINC_indelay,        
-- <!--Aldec correction start        
	GSR => GSR_local
-- Aldec correction end -->
      );
    
    INIPROC : process
    begin
    -- case CAL_BYPASS is
      if((CAL_BYPASS = "YES") or (CAL_BYPASS = "yes")) then
        CAL_BYPASS_BINARY <= '1';
      elsif((CAL_BYPASS = "NO") or (CAL_BYPASS= "no")) then
        CAL_BYPASS_BINARY <= '0';
      else
        assert FALSE report "Error : CAL_BYPASS = is not YES, NO." severity error;
      end if;
    -- end case;
    -- case CAL_CALIBRATION_MODE is
      if((CAL_CALIBRATION_MODE = "CALIBRATION") or (CAL_CALIBRATION_MODE = "calibration")) then
        CAL_CALIBRATION_MODE_BINARY <= '0';
      elsif((CAL_CALIBRATION_MODE = "NOCALIBRATION") or (CAL_CALIBRATION_MODE= "nocalibration")) then
        CAL_CALIBRATION_MODE_BINARY <= '1';
      else
        assert FALSE report "Error : CAL_CALIBRATION_MODE = is not CALIBRATION, NOCALIBRATION." severity error;
      end if;
    -- end case;
    -- case CAL_DELAY is
      if((CAL_DELAY = "QUARTER") or (CAL_DELAY = "quarter")) then
        CAL_DELAY_BINARY <= "00";
      elsif((CAL_DELAY = "FULL") or (CAL_DELAY= "full")) then
        CAL_DELAY_BINARY <= "11";
      elsif((CAL_DELAY = "HALF") or (CAL_DELAY= "half")) then
        CAL_DELAY_BINARY <= "01";
      elsif((CAL_DELAY = "THREEQUARTER") or (CAL_DELAY= "threequarter")) then
        CAL_DELAY_BINARY <= "10";
      else
        assert FALSE report "Error : CAL_DELAY = is not QUARTER, FULL, HALF, THREEQUARTER." severity error;
      end if;
    -- end case;
     -- case MEM_TYPE is
      if((MEM_TYPE = "DDR3") or (MEM_TYPE = "ddr3")) then
        MEM_TYPE_BINARY <= "000";
      elsif((MEM_TYPE = "DDR") or (MEM_TYPE= "ddr")) then
        MEM_TYPE_BINARY <= "010";
      elsif((MEM_TYPE = "DDR2") or (MEM_TYPE= "ddr2")) then
        MEM_TYPE_BINARY <= "001";
      elsif((MEM_TYPE = "MDDR") or (MEM_TYPE= "mddr")) then
        MEM_TYPE_BINARY <= "011";
      else
        assert FALSE report "Error : MEM_TYPE = is not DDR3, DDR, DDR2, MDDR." severity error;
      end if;
    -- end case;
    -- case MEM_BURST_LEN is
     if (MEM_BURST_LEN = 4)  then
      if (MEM_TYPE = "DDR3") then
        assert FALSE report "Error : MEM_BURST_LEN of 4 is not allowed for MEM_TYPE DDR3." severity error;
      else
        MEM_BURST_LEN_BINARY <= "010";
      end if;
     elsif (MEM_BURST_LEN = 8) then
      MEM_BURST_LEN_BINARY <= "011";
     else
      assert FALSE report "Error : MEM_BURST_LEN is not 4 or 8." severity error;
     end if;
    -- end case
    -- case MEM_ADDR_ORDER is
      if((MEM_ADDR_ORDER = "BANK_ROW_COLUMN") or (MEM_ADDR_ORDER = "bank_row_column")) then
        MEM_ADDR_ORDER_BINARY <= '0';
      elsif((MEM_ADDR_ORDER = "ROW_BANK_COLUMN") or (MEM_ADDR_ORDER= "row_bank_column")) then
        MEM_ADDR_ORDER_BINARY <= '1';
      else
        assert FALSE report "Error : MEM_ADDR_ORDER = is not BANK_ROW_COLUMN, ROW_BANK_COLUMN." severity error;
      end if;
    -- end case;
    -- case MEM_DDR1_2_ODS is
    if ((MEM_TYPE = "DDR2") or (MEM_TYPE = "DDR")) then
      if((MEM_DDR1_2_ODS = "FULL") or (MEM_DDR1_2_ODS = "full")) then
        MEM_DDR1_2_ODS_BINARY <= '0';
      elsif((MEM_DDR1_2_ODS = "REDUCED") or (MEM_DDR1_2_ODS= "reduced")) then
        MEM_DDR1_2_ODS_BINARY <= '1';
      else
        assert FALSE report "Error : MEM_DDR1_2_ODS = is not FULL, REDUCED." severity error;
      end if;
    end if;
    -- end case;
    -- case MEM_DDR2_3_HIGH_TEMP_SR is
    if ((MEM_TYPE = "DDR2") or (MEM_TYPE = "DDR3")) then
      if((MEM_DDR2_3_HIGH_TEMP_SR = "NORMAL") or (MEM_DDR2_3_HIGH_TEMP_SR = "normal")) then
        MEM_DDR2_3_HIGH_TEMP_SR_BINARY <= '0';
      elsif((MEM_DDR2_3_HIGH_TEMP_SR = "EXTENDED") or (MEM_DDR2_3_HIGH_TEMP_SR= "extended")) then
        MEM_DDR2_3_HIGH_TEMP_SR_BINARY <= '1';
      else
        assert FALSE report "Error : MEM_DDR2_3_HIGH_TEMP_SR = is not NORMAL, EXTENDED." severity error;
      end if;
    -- end case;
    -- case MEM_DDR2_3_PA_SR is
      if((MEM_DDR2_3_PA_SR = "FULL") or (MEM_DDR2_3_PA_SR = "full")) then
        MEM_DDR2_3_PA_SR_BINARY <= "000";
      elsif((MEM_DDR2_3_PA_SR = "EIGHTH1") or (MEM_DDR2_3_PA_SR= "eighth1")) then
        MEM_DDR2_3_PA_SR_BINARY <= "011";
      elsif((MEM_DDR2_3_PA_SR = "EIGHTH2") or (MEM_DDR2_3_PA_SR= "eighth2")) then
        MEM_DDR2_3_PA_SR_BINARY <= "111";
      elsif((MEM_DDR2_3_PA_SR = "HALF1") or (MEM_DDR2_3_PA_SR= "half1")) then
        MEM_DDR2_3_PA_SR_BINARY <= "001";
      elsif((MEM_DDR2_3_PA_SR = "HALF2") or (MEM_DDR2_3_PA_SR= "half2")) then
        MEM_DDR2_3_PA_SR_BINARY <= "101";
      elsif((MEM_DDR2_3_PA_SR = "QUARTER1") or (MEM_DDR2_3_PA_SR= "quarter1")) then
        MEM_DDR2_3_PA_SR_BINARY <= "010";
      elsif((MEM_DDR2_3_PA_SR = "QUARTER2") or (MEM_DDR2_3_PA_SR= "quarter2")) then
        MEM_DDR2_3_PA_SR_BINARY <= "110";
      elsif((MEM_DDR2_3_PA_SR = "THREEQUARTER") or (MEM_DDR2_3_PA_SR= "threequarter")) then
        MEM_DDR2_3_PA_SR_BINARY <= "100";
      else
        assert FALSE report "Error : MEM_DDR2_3_PA_SR = is not FULL, EIGHTH1, EIGHTH2, HALF1, HALF2, QUARTER1, QUARTER2, THREEQUARTER." severity error;
      end if;
    end if;
    -- end case;
    -- case MEM_DDR2_DIFF_DQS_EN is
    if (MEM_TYPE = "DDR2") then
      if((MEM_DDR2_DIFF_DQS_EN = "YES") or (MEM_DDR2_DIFF_DQS_EN = "yes")) then
        MEM_DDR2_DIFF_DQS_EN_BINARY <= '0';
      elsif((MEM_DDR2_DIFF_DQS_EN = "NO") or (MEM_DDR2_DIFF_DQS_EN= "no")) then
        MEM_DDR2_DIFF_DQS_EN_BINARY <= '1';
      else
        assert FALSE report "Error : MEM_DDR2_DIFF_DQS_EN = is not YES, NO." severity error;
      end if;
    -- end case;
    -- case MEM_DDR2_RTT is
      if((MEM_DDR2_RTT = "50OHMS") or (MEM_DDR2_RTT = "50ohms")) then
        MEM_DDR2_RTT_BINARY <= "11";
      elsif((MEM_DDR2_RTT = "75OHMS") or (MEM_DDR2_RTT= "75ohms")) then
        MEM_DDR2_RTT_BINARY <= "01";
      elsif((MEM_DDR2_RTT = "150OHMS") or (MEM_DDR2_RTT= "150ohms")) then
        MEM_DDR2_RTT_BINARY <= "10";
      elsif((MEM_DDR2_RTT = "OFF") or (MEM_DDR2_RTT= "off")) then
        MEM_DDR2_RTT_BINARY <= "00";
      else
        assert FALSE report "Error : MEM_DDR2_RTT = is not 50OHMS, 75OHMS, 150OHMS, OFF." severity error;
      end if;
      if ((MEM_DDR2_ADD_LATENCY >= 0) and (MEM_DDR2_ADD_LATENCY <= 5)) then
        MEM_DDR2_ADD_LATENCY_BINARY <= CONV_STD_LOGIC_VECTOR(MEM_DDR2_ADD_LATENCY, 3);
      else
       assert FALSE report "Error : MEM_DDR2_ADD_LATENCY is not in range 0 .. 5." severity error;
      end if;
      if ((MEM_DDR2_WRT_RECOVERY >= 2) and (MEM_DDR2_WRT_RECOVERY <= 6)) then
        MEM_DDR2_WRT_RECOVERY_BINARY <= CONV_STD_LOGIC_VECTOR(MEM_DDR2_WRT_RECOVERY, 3);
      else
       assert FALSE report "Error : MEM_DDR2_WRT_RECOVERY is not in range 2 .. 6." severity error;
      end if;

    end if;
    -- end case;
    -- case MEM_DDR3_ADD_LATENCY is
    if (MEM_TYPE = "DDR3") then
      if((MEM_DDR3_ADD_LATENCY = "OFF") or (MEM_DDR3_ADD_LATENCY = "off")) then
        MEM_DDR3_ADD_LATENCY_BINARY <= "00";
      elsif((MEM_DDR3_ADD_LATENCY = "CL1") or (MEM_DDR3_ADD_LATENCY= "cl1")) then
        MEM_DDR3_ADD_LATENCY_BINARY <= "01";
      elsif((MEM_DDR3_ADD_LATENCY = "CL2") or (MEM_DDR3_ADD_LATENCY= "cl2")) then
        MEM_DDR3_ADD_LATENCY_BINARY <= "10";
      else
        assert FALSE report "Error : MEM_DDR3_ADD_LATENCY = is not OFF, CL1, CL2." severity error;
      end if;
    -- end case;
    -- case MEM_DDR3_AUTO_SR is
      if((MEM_DDR3_AUTO_SR = "ENABLED") or (MEM_DDR3_AUTO_SR = "enabled")) then
        MEM_DDR3_AUTO_SR_BINARY <= '1';
      elsif((MEM_DDR3_AUTO_SR = "MANUAL") or (MEM_DDR3_AUTO_SR= "manual")) then
        MEM_DDR3_AUTO_SR_BINARY <= '0';
      else
        assert FALSE report "Error : MEM_DDR3_AUTO_SR = is not ENABLED, MANUAL." severity error;
      end if;
    -- end case;
    -- case MEM_DDR3_DYN_WRT_ODT is
      if((MEM_DDR3_DYN_WRT_ODT = "OFF") or (MEM_DDR3_DYN_WRT_ODT = "off")) then
        MEM_DDR3_DYN_WRT_ODT_BINARY <= "00";
      elsif((MEM_DDR3_DYN_WRT_ODT = "DIV2") or (MEM_DDR3_DYN_WRT_ODT= "div2")) then
        MEM_DDR3_DYN_WRT_ODT_BINARY <= "01";
      elsif((MEM_DDR3_DYN_WRT_ODT = "DIV4") or (MEM_DDR3_DYN_WRT_ODT= "div4")) then
        MEM_DDR3_DYN_WRT_ODT_BINARY <= "10";
      else
        assert FALSE report "Error : MEM_DDR3_DYN_WRT_ODT = is not OFF, DIV2, DIV4." severity error;
      end if;
    -- end case;
    -- case MEM_DDR3_ODS is
      if((MEM_DDR3_ODS = "DIV7") or (MEM_DDR3_ODS = "div7")) then
        MEM_DDR3_ODS_BINARY <= "01";
      elsif((MEM_DDR3_ODS = "DIV6") or (MEM_DDR3_ODS= "div6")) then
        MEM_DDR3_ODS_BINARY <= "00";
      else
        assert FALSE report "Error : MEM_DDR3_ODS = is not DIV7, DIV6." severity error;
      end if;
    -- end case;
    -- case MEM_DDR3_RTT is
      if((MEM_DDR3_RTT = "DIV2") or (MEM_DDR3_RTT = "div2")) then
        MEM_DDR3_RTT_BINARY <= "010";
      elsif((MEM_DDR3_RTT = "DIV4") or (MEM_DDR3_RTT= "div4")) then
        MEM_DDR3_RTT_BINARY <= "001";
      elsif((MEM_DDR3_RTT = "DIV6") or (MEM_DDR3_RTT= "div6")) then
        MEM_DDR3_RTT_BINARY <= "011";
      elsif((MEM_DDR3_RTT = "DIV8") or (MEM_DDR3_RTT= "div8")) then
        MEM_DDR3_RTT_BINARY <= "100";
      elsif((MEM_DDR3_RTT = "DIV12") or (MEM_DDR3_RTT= "div12")) then
        MEM_DDR3_RTT_BINARY <= "101";
      elsif((MEM_DDR3_RTT = "OFF") or (MEM_DDR3_RTT= "off")) then
        MEM_DDR3_RTT_BINARY <= "000";
      else
        assert FALSE report "Error : MEM_DDR3_RTT = is not DIV2, DIV4, DIV6, DIV8, DIV12, OFF." severity error;
      end if;
      if ((MEM_DDR3_CAS_LATENCY >= 5) and (MEM_DDR3_CAS_LATENCY <= 10)) then
      MEM_DDR3_CAS_LATENCY_BINARY <= CONV_STD_LOGIC_VECTOR(MEM_DDR3_CAS_LATENCY, 4);
      else
        assert FALSE report "Error : MEM_DDR3_CAS_LATENCY is not in range 5 .. 10." severity error;
      end if;
      if ((MEM_DDR3_CAS_WR_LATENCY >= 5) and (MEM_DDR3_CAS_WR_LATENCY <= 8)) then
       MEM_DDR3_CAS_WR_LATENCY_BINARY <= CONV_STD_LOGIC_VECTOR(MEM_DDR3_CAS_WR_LATENCY, 3);
      else
        assert FALSE report "Error : MEM_DDR3_CAS_WR_LATENCY is not in range 5 .. 8." severity error;
      end if;
      if ((MEM_DDR3_WRT_RECOVERY = 5) or (MEM_DDR3_WRT_RECOVERY = 6) or (MEM_DDR3_WRT_RECOVERY = 7) or (MEM_DDR3_WRT_RECOVERY = 8) or (MEM_DDR3_WRT_RECOVERY = 10) or (MEM_DDR3_WRT_RECOVERY = 12)) then
        MEM_DDR3_WRT_RECOVERY_BINARY <= CONV_STD_LOGIC_VECTOR(MEM_DDR3_WRT_RECOVERY, 3);
      else
       assert FALSE report "Error : MEM_DDR3_WRT_RECOVERY is not 5, 6, 7, 8, 10 or 12." severity error;
      end if;
    end if;
    -- end case;
    -- case MEM_MDDR_ODS is
    if (MEM_TYPE = "MDDR") then
      if((MEM_MDDR_ODS = "FULL") or (MEM_MDDR_ODS = "full")) then
        MEM_MDDR_ODS_BINARY <= "000";
      elsif((MEM_MDDR_ODS = "HALF") or (MEM_MDDR_ODS= "half")) then
        MEM_MDDR_ODS_BINARY <= "001";
      elsif((MEM_MDDR_ODS = "QUARTER") or (MEM_MDDR_ODS= "quarter")) then
        MEM_MDDR_ODS_BINARY <= "010";
      elsif((MEM_MDDR_ODS = "THREEQUARTERS") or (MEM_MDDR_ODS= "threequarters")) then
        MEM_MDDR_ODS_BINARY <= "100";
      else
        assert FALSE report "Error : MEM_MDDR_ODS = is not FULL, HALF, QUARTER, THREEQUARTERS." severity error;
      end if;
    -- end case;
    -- case MEM_MOBILE_PA_SR is
      if((MEM_MOBILE_PA_SR = "FULL") or (MEM_MOBILE_PA_SR = "full")) then
        MEM_MOBILE_PA_SR_BINARY <= "000";
      elsif((MEM_MOBILE_PA_SR = "HALF") or (MEM_MOBILE_PA_SR= "half")) then
        MEM_MOBILE_PA_SR_BINARY <= "001";
      else
        assert FALSE report "Error : MEM_MOBILE_PA_SR = is not FULL, HALF." severity error;
      end if;
       if ((MEM_MOBILE_TC_SR >= 0) and (MEM_MOBILE_TC_SR <= 3)) then
        MEM_MOBILE_TC_SR_BINARY <= CONV_STD_LOGIC_VECTOR(MEM_MOBILE_TC_SR, 2);
       else
        assert FALSE report "Error : MEM_MOBILE_TC_SR is not in range 0 .. 3." severity error;
      end if;
     end if;
    -- end case;
    case ARB_NUM_TIME_SLOTS is
      when  12   =>  ARB_NUM_TIME_SLOTS_BINARY <= '1';
      when  10   =>  ARB_NUM_TIME_SLOTS_BINARY <= '0';
      when others  =>  assert FALSE report "Error : ARB_NUM_TIME_SLOTS is 12 or 10." severity error;
    end case;
    case MEM_BA_SIZE is
      when  3   =>  MEM_BA_SIZE_BINARY <= '1';
      when  2   =>  MEM_BA_SIZE_BINARY <= '0';
      when others  =>  assert FALSE report "Error : MEM_BA_SIZE is not in range 2 .. 3." severity error;
    end case;
    if ((CAL_CLK_DIV = 1) or (CAL_CLK_DIV = 2) or (CAL_CLK_DIV = 4) or (CAL_CLK_DIV = 8)) then
      CAL_CLK_DIV_BINARY <= CONV_STD_LOGIC_VECTOR(CAL_CLK_DIV, 3);
    else
      assert FALSE report "Error : CAL_CLK_DIV is not  1, 2, 4 or 8." severity error;
    end if;
    if ((MEM_CAS_LATENCY >= 1) and (MEM_CAS_LATENCY <= 6)) then
      MEM_CAS_LATENCY_BINARY <= CONV_STD_LOGIC_VECTOR(MEM_CAS_LATENCY, 3);
    else
      assert FALSE report "Error : MEM_CAS_LATENCY is not in range 1 .. 6." severity error;
    end if;
    if ((MEM_CA_SIZE >= 9) and (MEM_CA_SIZE <= 12)) then
      MEM_CA_SIZE_BINARY <= CONV_STD_LOGIC_VECTOR(MEM_CA_SIZE, 2);
    else
      assert FALSE report "Error : MEM_CA_SIZE is not in range 9 .. 12." severity error;
    end if;
    if ((MEM_RAS_VAL >= 0) and (MEM_RAS_VAL <= 31)) then
      MEM_RAS_VAL_BINARY <= CONV_STD_LOGIC_VECTOR(MEM_RAS_VAL, 5);
    else
      assert FALSE report "Error : MEM_RAS_VAL is not in range 0 .. 31." severity error;
    end if;
    if ((MEM_RA_SIZE >= 12) and (MEM_RA_SIZE <= 15)) then
      MEM_RA_SIZE_BINARY <= CONV_STD_LOGIC_VECTOR(MEM_RA_SIZE, 2);
    else
      assert FALSE report "Error : MEM_RA_SIZE is not in range 12 .. 15." severity error;
    end if;
    if ((MEM_RCD_VAL >= 0) and (MEM_RCD_VAL <= 7)) then
      MEM_RCD_VAL_BINARY <= CONV_STD_LOGIC_VECTOR(MEM_RCD_VAL, 3);
    else
      assert FALSE report "Error : MEM_RCD_VAL is not in range 0 .. 7." severity error;
    end if;
    if ((MEM_REFI_VAL >= 0) and (MEM_REFI_VAL <= 4095)) then
      MEM_REFI_VAL_BINARY <= CONV_STD_LOGIC_VECTOR(MEM_REFI_VAL, 12);
    else
      assert FALSE report "Error : MEM_REFI_VAL is not in range 0 .. 4095." severity error;
    end if;
    if ((MEM_RFC_VAL >= 0) and (MEM_RFC_VAL <= 255)) then
      MEM_RFC_VAL_BINARY <= CONV_STD_LOGIC_VECTOR(MEM_RFC_VAL, 8);
    else
      assert FALSE report "Error : MEM_RFC_VAL is not in range 0 .. 255." severity error;
    end if;
    if ((MEM_RP_VAL >= 0) and (MEM_RP_VAL <= 15)) then
      MEM_RP_VAL_BINARY <= CONV_STD_LOGIC_VECTOR(MEM_RP_VAL, 4);
    else
      assert FALSE report "Error : MEM_RP_VAL is not in range 0 .. 15." severity error;
    end if;
    if ((MEM_RTP_VAL >= 0) and (MEM_RTP_VAL <= 7)) then
      MEM_RTP_VAL_BINARY <= CONV_STD_LOGIC_VECTOR(MEM_RTP_VAL, 3);
    else
      assert FALSE report "Error : MEM_RTP_VAL is not in range 0 .. 7." severity error;
    end if;
    if ((MEM_WIDTH = 4) or (MEM_WIDTH = 8) or (MEM_WIDTH = 16)) then
      MEM_WIDTH_BINARY <= CONV_STD_LOGIC_VECTOR(MEM_WIDTH, 2);
    else
      assert FALSE report "Error : MEM_WIDTH is not 4, 8 or 16." severity error;
    end if;
    if ((MEM_WR_VAL >= 0) and (MEM_WR_VAL <= 7)) then
      MEM_WR_VAL_BINARY <= CONV_STD_LOGIC_VECTOR(MEM_WR_VAL, 3);
    else
      assert FALSE report "Error : MEM_WR_VAL is not in range 0 .. 7." severity error;
    end if;
    if ((MEM_WTR_VAL >= 0) and (MEM_WTR_VAL <= 7)) then
      MEM_WTR_VAL_BINARY <= CONV_STD_LOGIC_VECTOR(MEM_WTR_VAL, 3);
    else
      assert FALSE report "Error : MEM_WTR_VAL is not in range 0 .. 7." severity error;
    end if;
     -- case PORT_CONFIG is
      if((PORT_CONFIG = "B32_B32_B32_B32") or (PORT_CONFIG = "b32_b32_b32_b32")) then
        PORT_CONFIG_BINARY <= "001";
      elsif((PORT_CONFIG = "B32_B32_R32_R32_R32_R32") or (PORT_CONFIG= "b32_b32_r32_r32_r32_r32")) then
        PORT_CONFIG_BINARY <= "000";
      elsif((PORT_CONFIG = "B32_B32_R32_R32_R32_W32") or (PORT_CONFIG= "b32_b32_r32_r32_r32_w32")) then
        PORT_CONFIG_BINARY <= "000";
      elsif((PORT_CONFIG = "B32_B32_R32_R32_W32_R32") or (PORT_CONFIG= "b32_b32_r32_r32_w32_r32")) then
        PORT_CONFIG_BINARY <= "000";
      elsif((PORT_CONFIG = "B32_B32_R32_R32_W32_W32") or (PORT_CONFIG= "b32_b32_r32_r32_w32_w32")) then
        PORT_CONFIG_BINARY <= "000";
      elsif((PORT_CONFIG = "B32_B32_R32_W32_R32_R32") or (PORT_CONFIG= "b32_b32_r32_w32_r32_r32")) then
        PORT_CONFIG_BINARY <= "000";
      elsif((PORT_CONFIG = "B32_B32_R32_W32_R32_W32") or (PORT_CONFIG= "b32_b32_r32_w32_r32_w32")) then
        PORT_CONFIG_BINARY <= "000";
      elsif((PORT_CONFIG = "B32_B32_R32_W32_W32_R32") or (PORT_CONFIG= "b32_b32_r32_w32_w32_r32")) then
        PORT_CONFIG_BINARY <= "000";
      elsif((PORT_CONFIG = "B32_B32_R32_W32_W32_W32") or (PORT_CONFIG= "b32_b32_r32_w32_w32_w32")) then
        PORT_CONFIG_BINARY <= "000";
      elsif((PORT_CONFIG = "B32_B32_W32_R32_R32_R32") or (PORT_CONFIG= "b32_b32_w32_r32_r32_r32")) then
        PORT_CONFIG_BINARY <= "000";
      elsif((PORT_CONFIG = "B32_B32_W32_R32_R32_W32") or (PORT_CONFIG= "b32_b32_w32_r32_r32_w32")) then
        PORT_CONFIG_BINARY <= "000";
      elsif((PORT_CONFIG = "B32_B32_W32_R32_W32_R32") or (PORT_CONFIG= "b32_b32_w32_r32_w32_r32")) then
        PORT_CONFIG_BINARY <= "000";
      elsif((PORT_CONFIG = "B32_B32_W32_R32_W32_W32") or (PORT_CONFIG= "b32_b32_w32_r32_w32_w32")) then
        PORT_CONFIG_BINARY <= "000";
      elsif((PORT_CONFIG = "B32_B32_W32_W32_R32_R32") or (PORT_CONFIG= "b32_b32_w32_w32_r32_r32")) then
        PORT_CONFIG_BINARY <= "000";
      elsif((PORT_CONFIG = "B32_B32_W32_W32_R32_W32") or (PORT_CONFIG= "b32_b32_w32_w32_r32_w32")) then
        PORT_CONFIG_BINARY <= "000";
      elsif((PORT_CONFIG = "B32_B32_W32_W32_W32_R32") or (PORT_CONFIG= "b32_b32_w32_w32_w32_r32")) then
        PORT_CONFIG_BINARY <= "000";
      elsif((PORT_CONFIG = "B32_B32_W32_W32_W32_W32") or (PORT_CONFIG= "b32_b32_w32_w32_w32_w32")) then
        PORT_CONFIG_BINARY <= "000";
      elsif((PORT_CONFIG = "B64_B32_B32") or (PORT_CONFIG= "b64_b32_b32")) then
        PORT_CONFIG_BINARY <= "010";
      elsif((PORT_CONFIG = "B64_B64") or (PORT_CONFIG= "b64_b64")) then
        PORT_CONFIG_BINARY <= "011";
      elsif((PORT_CONFIG = "B128") or (PORT_CONFIG= "b128")) then
        PORT_CONFIG_BINARY <= "100";
      else
        assert FALSE report "Error : PORT_CONFIG = is not B32_B32_B32_B32, B32_B32_R32_R32_R32_R32, B32_B32_R32_R32_R32_W32, B32_B32_R32_R32_W32_R32, B32_B32_R32_R32_W32_W32, B32_B32_R32_W32_R32_R32, B32_B32_R32_W32_R32_W32, B32_B32_R32_W32_W32_R32, B32_B32_R32_W32_W32_W32, B32_B32_W32_R32_R32_R32, B32_B32_W32_R32_R32_W32, B32_B32_W32_R32_W32_R32, B32_B32_W32_R32_W32_W32, B32_B32_W32_W32_R32_R32, B32_B32_W32_W32_R32_W32, B32_B32_W32_W32_W32_R32, B32_B32_W32_W32_W32_W32, B64_B32_B32, B64_B64, B128." severity error;
      end if;
    -- end case;
    wait;
    end process INIPROC;
    ADDR <= ADDR_out;
    BA <= BA_out;
    CAS <= CAS_out;
    CKE <= CKE_out;
    DQIOWEN0 <= DQIOWEN0_out;
    DQON <= DQON_out;
    DQOP <= DQOP_out;
    DQSIOWEN90N <= DQSIOWEN90N_out;
    DQSIOWEN90P <= DQSIOWEN90P_out;
    IOIDRPADD <= IOIDRPADD_out;
    IOIDRPADDR <= IOIDRPADDR_out;
    IOIDRPBROADCAST <= IOIDRPBROADCAST_out;
    IOIDRPCLK <= IOIDRPCLK_out;
    IOIDRPCS <= IOIDRPCS_out;
    IOIDRPSDO <= IOIDRPSDO_out;
    IOIDRPTRAIN <= IOIDRPTRAIN_out;
    IOIDRPUPDATE <= IOIDRPUPDATE_out;
    LDMN <= LDMN_out;
    LDMP <= LDMP_out;
    ODT <= ODT_out;
    P0CMDEMPTY <= P0CMDEMPTY_out;
    P0CMDFULL <= P0CMDFULL_out;
    P0RDCOUNT <= P0RDCOUNT_out;
    P0RDDATA <= P0RDDATA_out;
    P0RDEMPTY <= P0RDEMPTY_out;
    P0RDERROR <= P0RDERROR_out;
    P0RDFULL <= P0RDFULL_out;
    P0RDOVERFLOW <= P0RDOVERFLOW_out;
    P0WRCOUNT <= P0WRCOUNT_out;
    P0WREMPTY <= P0WREMPTY_out;
    P0WRERROR <= P0WRERROR_out;
    P0WRFULL <= P0WRFULL_out;
    P0WRUNDERRUN <= P0WRUNDERRUN_out;
    P1CMDEMPTY <= P1CMDEMPTY_out;
    P1CMDFULL <= P1CMDFULL_out;
    P1RDCOUNT <= P1RDCOUNT_out;
    P1RDDATA <= P1RDDATA_out;
    P1RDEMPTY <= P1RDEMPTY_out;
    P1RDERROR <= P1RDERROR_out;
    P1RDFULL <= P1RDFULL_out;
    P1RDOVERFLOW <= P1RDOVERFLOW_out;
    P1WRCOUNT <= P1WRCOUNT_out;
    P1WREMPTY <= P1WREMPTY_out;
    P1WRERROR <= P1WRERROR_out;
    P1WRFULL <= P1WRFULL_out;
    P1WRUNDERRUN <= P1WRUNDERRUN_out;
    P2CMDEMPTY <= P2CMDEMPTY_out;
    P2CMDFULL <= P2CMDFULL_out;
    P2COUNT <= P2COUNT_out;
    P2EMPTY <= P2EMPTY_out;
    P2ERROR <= P2ERROR_out;
    P2FULL <= P2FULL_out;
    P2RDDATA <= P2RDDATA_out;
    P2RDOVERFLOW <= P2RDOVERFLOW_out;
    P2WRUNDERRUN <= P2WRUNDERRUN_out;
    P3CMDEMPTY <= P3CMDEMPTY_out;
    P3CMDFULL <= P3CMDFULL_out;
    P3COUNT <= P3COUNT_out;
    P3EMPTY <= P3EMPTY_out;
    P3ERROR <= P3ERROR_out;
    P3FULL <= P3FULL_out;
    P3RDDATA <= P3RDDATA_out;
    P3RDOVERFLOW <= P3RDOVERFLOW_out;
    P3WRUNDERRUN <= P3WRUNDERRUN_out;
    P4CMDEMPTY <= P4CMDEMPTY_out;
    P4CMDFULL <= P4CMDFULL_out;
    P4COUNT <= P4COUNT_out;
    P4EMPTY <= P4EMPTY_out;
    P4ERROR <= P4ERROR_out;
    P4FULL <= P4FULL_out;
    P4RDDATA <= P4RDDATA_out;
    P4RDOVERFLOW <= P4RDOVERFLOW_out;
    P4WRUNDERRUN <= P4WRUNDERRUN_out;
    P5CMDEMPTY <= P5CMDEMPTY_out;
    P5CMDFULL <= P5CMDFULL_out;
    P5COUNT <= P5COUNT_out;
    P5EMPTY <= P5EMPTY_out;
    P5ERROR <= P5ERROR_out;
    P5FULL <= P5FULL_out;
    P5RDDATA <= P5RDDATA_out;
    P5RDOVERFLOW <= P5RDOVERFLOW_out;
    P5WRUNDERRUN <= P5WRUNDERRUN_out;
    RAS <= RAS_out;
    RST <= RST_out;
    SELFREFRESHMODE <= SELFREFRESHMODE_out;
    STATUS <= STATUS_out;
    UDMN <= UDMN_out;
    UDMP <= UDMP_out;
    UOCALSTART <= UOCALSTART_out;
    UOCMDREADYIN <= UOCMDREADYIN_out;
    UODATA <= UODATA_out;
    UODATAVALID <= UODATAVALID_out;
    UODONECAL <= UODONECAL_out;
    UOREFRSHFLAG <= UOREFRSHFLAG_out;
    UOSDO <= UOSDO_out;
    WE <= WE_out;
  end MCB_V;
